/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.util.Arrays;
import org.apache.beam.sdk.io.TextIO;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_TextIO_ReadFiles
extends TextIO.ReadFiles {
    private final long desiredBundleSizeBytes;
    private final byte @Nullable [] delimiter;
    private final int skipHeaderLines;

    private AutoValue_TextIO_ReadFiles(long desiredBundleSizeBytes, byte @Nullable [] delimiter, int skipHeaderLines) {
        this.desiredBundleSizeBytes = desiredBundleSizeBytes;
        this.delimiter = delimiter;
        this.skipHeaderLines = skipHeaderLines;
    }

    @Override
    long getDesiredBundleSizeBytes() {
        return this.desiredBundleSizeBytes;
    }

    @Override
    byte @Nullable [] getDelimiter() {
        return this.delimiter;
    }

    @Override
    int getSkipHeaderLines() {
        return this.skipHeaderLines;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TextIO.ReadFiles) {
            TextIO.ReadFiles that = (TextIO.ReadFiles)o;
            return this.desiredBundleSizeBytes == that.getDesiredBundleSizeBytes() && Arrays.equals(this.delimiter, that instanceof AutoValue_TextIO_ReadFiles ? ((AutoValue_TextIO_ReadFiles)that).delimiter : that.getDelimiter()) && this.skipHeaderLines == that.getSkipHeaderLines();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.desiredBundleSizeBytes >>> 32 ^ this.desiredBundleSizeBytes);
        h$ *= 1000003;
        h$ ^= Arrays.hashCode(this.delimiter);
        h$ *= 1000003;
        return h$ ^= this.skipHeaderLines;
    }

    @Override
    TextIO.ReadFiles.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TextIO.ReadFiles.Builder {
        private Long desiredBundleSizeBytes;
        private byte @Nullable [] delimiter;
        private Integer skipHeaderLines;

        Builder() {
        }

        private Builder(TextIO.ReadFiles source) {
            this.desiredBundleSizeBytes = source.getDesiredBundleSizeBytes();
            this.delimiter = source.getDelimiter();
            this.skipHeaderLines = source.getSkipHeaderLines();
        }

        @Override
        TextIO.ReadFiles.Builder setDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            this.desiredBundleSizeBytes = desiredBundleSizeBytes;
            return this;
        }

        @Override
        TextIO.ReadFiles.Builder setDelimiter(byte @Nullable [] delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        TextIO.ReadFiles.Builder setSkipHeaderLines(int skipHeaderLines) {
            this.skipHeaderLines = skipHeaderLines;
            return this;
        }

        @Override
        TextIO.ReadFiles build() {
            if (this.desiredBundleSizeBytes == null || this.skipHeaderLines == null) {
                StringBuilder missing = new StringBuilder();
                if (this.desiredBundleSizeBytes == null) {
                    missing.append(" desiredBundleSizeBytes");
                }
                if (this.skipHeaderLines == null) {
                    missing.append(" skipHeaderLines");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TextIO_ReadFiles(this.desiredBundleSizeBytes, this.delimiter, this.skipHeaderLines);
        }
    }
}

