/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.convert.Converter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMdColumnUniqueness
implements MetadataHandler<BuiltInMetadata.ColumnUniqueness> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdColumnUniqueness(), BuiltInMetadata.ColumnUniqueness.Handler.class);
    static final Set<SqlKind> PASSTHROUGH_AGGREGATIONS = ImmutableSet.of((Object)((Object)SqlKind.MIN), (Object)((Object)SqlKind.MAX), (Object)((Object)SqlKind.ANY_VALUE));

    private RelMdColumnUniqueness() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.ColumnUniqueness> getDef() {
        return BuiltInMetadata.ColumnUniqueness.DEF;
    }

    public Boolean areColumnsUnique(TableScan scan, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        BuiltInMetadata.ColumnUniqueness.Handler handler = scan.getTable().unwrap(BuiltInMetadata.ColumnUniqueness.Handler.class);
        if (handler != null) {
            return handler.areColumnsUnique(scan, mq, columns, ignoreNulls);
        }
        return scan.getTable().isKey(columns);
    }

    public @Nullable Boolean areColumnsUnique(Filter rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        return mq.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public @Nullable Boolean areColumnsUnique(RelNode rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        return null;
    }

    public Boolean areColumnsUnique(SetOp rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        return !rel.all && columns.nextClearBit(0) >= rel.getRowType().getFieldCount();
    }

    public Boolean areColumnsUnique(Intersect rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        if (this.areColumnsUnique((SetOp)rel, mq, columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq), ignoreNulls).booleanValue()) {
            return true;
        }
        for (RelNode input : rel.getInputs()) {
            Boolean b = mq.areColumnsUnique(input, columns, ignoreNulls);
            if (b == null || !b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public @Nullable Boolean areColumnsUnique(Minus rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        if (this.areColumnsUnique((SetOp)rel, mq, columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq), ignoreNulls).booleanValue()) {
            return true;
        }
        return mq.areColumnsUnique(rel.getInput(0), columns, ignoreNulls);
    }

    public @Nullable Boolean areColumnsUnique(Sort rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        Double maxRowCount = mq.getMaxRowCount(rel);
        if (maxRowCount != null && maxRowCount <= 1.0) {
            return true;
        }
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        return mq.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public @Nullable Boolean areColumnsUnique(TableModify rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        return mq.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public @Nullable Boolean areColumnsUnique(Exchange rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        return mq.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public @Nullable Boolean areColumnsUnique(Correlate rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        switch (rel.getJoinType()) {
            case ANTI: 
            case SEMI: {
                return mq.areColumnsUnique(rel.getLeft(), columns, ignoreNulls);
            }
            case LEFT: 
            case INNER: {
                Pair<ImmutableBitSet, ImmutableBitSet> leftAndRightColumns = RelMdColumnUniqueness.splitLeftAndRightColumns(rel.getLeft().getRowType().getFieldCount(), columns);
                ImmutableBitSet leftColumns = (ImmutableBitSet)leftAndRightColumns.left;
                ImmutableBitSet rightColumns = (ImmutableBitSet)leftAndRightColumns.right;
                RelNode left = rel.getLeft();
                RelNode right = rel.getRight();
                if (leftColumns.cardinality() > 0 && rightColumns.cardinality() > 0) {
                    Boolean leftUnique = mq.areColumnsUnique(left, leftColumns, ignoreNulls);
                    Boolean rightUnique = mq.areColumnsUnique(right, rightColumns, ignoreNulls);
                    if (leftUnique == null || rightUnique == null) {
                        return null;
                    }
                    return leftUnique != false && rightUnique != false;
                }
                return null;
            }
        }
        throw new IllegalStateException("Unknown join type " + (Object)((Object)rel.getJoinType()) + " for correlate relation " + rel);
    }

    public @Nullable Boolean areColumnsUnique(Project rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        return RelMdColumnUniqueness.areProjectColumnsUnique(rel, mq, columns, ignoreNulls, rel.getProjects());
    }

    public @Nullable Boolean areColumnsUnique(Calc rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        RexProgram program = rel.getProgram();
        return RelMdColumnUniqueness.areProjectColumnsUnique(rel, mq, columns, ignoreNulls, Util.transform(program.getProjectList(), program::expandLocalRef));
    }

    private static @Nullable Boolean areProjectColumnsUnique(SingleRel rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls, List<RexNode> projExprs) {
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        ImmutableBitSet.Builder childColumns = ImmutableBitSet.builder();
        for (int bit : columns) {
            RelDataType origType;
            RelDataType castType;
            RexNode castOperand;
            RexCall call;
            RexNode projExpr = projExprs.get(bit);
            if (projExpr instanceof RexInputRef) {
                childColumns.set(((RexInputRef)projExpr).getIndex());
                continue;
            }
            if (!(projExpr instanceof RexCall) || !ignoreNulls || (call = (RexCall)projExpr).getOperator() != SqlStdOperatorTable.CAST || !((castOperand = call.getOperands().get(0)) instanceof RexInputRef) || !(castType = typeFactory.createTypeWithNullability(projExpr.getType(), true)).equals(origType = typeFactory.createTypeWithNullability(castOperand.getType(), true))) continue;
            childColumns.set(((RexInputRef)castOperand).getIndex());
        }
        return mq.areColumnsUnique(rel.getInput(), childColumns.build(), ignoreNulls);
    }

    public @Nullable Boolean areColumnsUnique(Join rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        if (!rel.getJoinType().projectsRight()) {
            return mq.areColumnsUnique(left, columns, ignoreNulls);
        }
        int leftColumnCount = rel.getLeft().getRowType().getFieldCount();
        Pair<ImmutableBitSet, ImmutableBitSet> leftAndRightColumns = RelMdColumnUniqueness.splitLeftAndRightColumns(leftColumnCount, columns);
        ImmutableBitSet leftColumns = (ImmutableBitSet)leftAndRightColumns.left;
        ImmutableBitSet rightColumns = (ImmutableBitSet)leftAndRightColumns.right;
        if (!ignoreNulls && rel.getJoinType() == JoinRelType.FULL && leftColumns.cardinality() > 0 && rightColumns.cardinality() > 0) {
            return false;
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        if (rel.getJoinType() == JoinRelType.INNER) {
            Double leftMaxRowCount;
            Double rightMaxRowCount = mq.getMaxRowCount(right);
            if (rightMaxRowCount != null && rightMaxRowCount <= 1.0) {
                leftColumns = leftColumns.union(joinInfo.leftSet());
            }
            if ((leftMaxRowCount = mq.getMaxRowCount(left)) != null && leftMaxRowCount <= 1.0) {
                rightColumns = rightColumns.union(joinInfo.rightSet());
            }
        }
        Boolean leftUnique = mq.areColumnsUnique(left, leftColumns, ignoreNulls);
        Boolean rightUnique = mq.areColumnsUnique(right, rightColumns, ignoreNulls);
        if (leftColumns.cardinality() > 0 && rightColumns.cardinality() > 0) {
            if (leftUnique == null || rightUnique == null) {
                return null;
            }
            return leftUnique != false && rightUnique != false;
        }
        if (leftColumns.cardinality() > 0) {
            if (rel.getJoinType().generatesNullsOnLeft()) {
                return false;
            }
            Boolean rightJoinColsUnique = mq.areColumnsUnique(right, joinInfo.rightSet(), ignoreNulls);
            if (rightJoinColsUnique == null || leftUnique == null) {
                return null;
            }
            return rightJoinColsUnique != false && leftUnique != false;
        }
        if (rightColumns.cardinality() > 0) {
            if (rel.getJoinType().generatesNullsOnRight()) {
                return false;
            }
            Boolean leftJoinColsUnique = mq.areColumnsUnique(left, joinInfo.leftSet(), ignoreNulls);
            if (leftJoinColsUnique == null || rightUnique == null) {
                return null;
            }
            return leftJoinColsUnique != false && rightUnique != false;
        }
        return false;
    }

    public @Nullable Boolean areColumnsUnique(Aggregate rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        Double maxRowCount = mq.getMaxRowCount(rel);
        if (maxRowCount != null && maxRowCount <= 1.0) {
            return true;
        }
        if (Aggregate.isSimple(rel) || ignoreNulls) {
            ImmutableBitSet groupKey;
            boolean contained = (columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq)).contains(groupKey = ImmutableBitSet.range(rel.getGroupCount()));
            if (contained) {
                return true;
            }
            if (!Aggregate.isSimple(rel)) {
                return false;
            }
            if (Aggregate.isSimple(rel)) {
                ImmutableBitSet inputCols = ImmutableBitSet.builder().addAll(columns.intersect(rel.getGroupSet())).addAll(columns.toList().stream().map(col -> col - rel.getGroupSet().length()).filter(col -> col >= 0).map(col -> rel.getAggCallList().get((int)col)).filter(call -> PASSTHROUGH_AGGREGATIONS.contains((Object)call.getAggregation().getKind())).map(call -> call.getArgList().get(0)).collect(Collectors.toSet())).build();
                return mq.areColumnsUnique(rel.getInput(), inputCols, ignoreNulls);
            }
            ImmutableBitSet commonKeys = columns.intersect(groupKey);
            if (commonKeys.isEmpty()) {
                return false;
            }
            ImmutableBitSet.Builder targetColumns = ImmutableBitSet.builder();
            for (int key : commonKeys) {
                targetColumns.set(rel.getGroupSet().nth(key));
            }
            return mq.areColumnsUnique(rel.getInput(), targetColumns.build(), ignoreNulls);
        }
        return null;
    }

    public Boolean areColumnsUnique(Values rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        if (rel.tuples.size() < 2) {
            return true;
        }
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        HashSet<ImmutableList> set = new HashSet<ImmutableList>();
        ArrayList<NullSentinel> values = new ArrayList<NullSentinel>(columns.cardinality());
        for (ImmutableList tuple : rel.tuples) {
            for (int column : columns) {
                RexLiteral literal = (RexLiteral)tuple.get(column);
                Comparable value = literal.getValueAs(Comparable.class);
                values.add((NullSentinel)((Object)(value == null ? NullSentinel.INSTANCE : value)));
            }
            if (!set.add(ImmutableList.copyOf(values))) {
                return false;
            }
            values.clear();
        }
        return true;
    }

    public @Nullable Boolean areColumnsUnique(Converter rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        return mq.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public @Nullable Boolean areColumnsUnique(RelSubset rel, RelMetadataQuery mq, ImmutableBitSet columns, boolean ignoreNulls) {
        columns = RelMdColumnUniqueness.decorateWithConstantColumnsFromPredicates(columns, rel, mq);
        for (RelNode rel2 : rel.getRels()) {
            if (!(rel2 instanceof Aggregate) && !(rel2 instanceof Filter) && !(rel2 instanceof Values) && !(rel2 instanceof Sort) && !(rel2 instanceof TableScan) && !(rel2 instanceof Project)) continue;
            try {
                Boolean unique = mq.areColumnsUnique(rel2, columns, ignoreNulls);
                if (unique != null) {
                    if (!unique.booleanValue()) continue;
                    return true;
                }
                return null;
            }
            catch (CyclicMetadataException cyclicMetadataException) {
            }
        }
        return false;
    }

    private static Pair<ImmutableBitSet, ImmutableBitSet> splitLeftAndRightColumns(int leftCount, ImmutableBitSet columns) {
        ImmutableBitSet.Builder leftBuilder = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightBuilder = ImmutableBitSet.builder();
        for (int bit : columns) {
            if (bit < leftCount) {
                leftBuilder.set(bit);
                continue;
            }
            rightBuilder.set(bit - leftCount);
        }
        return Pair.of(leftBuilder.build(), rightBuilder.build());
    }

    private static ImmutableBitSet decorateWithConstantColumnsFromPredicates(ImmutableBitSet checkingColumns, RelNode rel, RelMetadataQuery mq) {
        ImmutableBitSet constantIndexes;
        RelOptPredicateList predicates = mq.getPulledUpPredicates(rel);
        if (!RelOptPredicateList.isEmpty(predicates) && !(constantIndexes = RelMdColumnUniqueness.getConstantColumnSet(predicates)).isEmpty()) {
            return checkingColumns.union(ImmutableBitSet.of(constantIndexes));
        }
        return checkingColumns;
    }

    static ImmutableBitSet getConstantColumnSet(RelOptPredicateList relOptPredicateList) {
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        relOptPredicateList.constantMap.keySet().stream().filter(RexInputRef.class::isInstance).map(RexInputRef.class::cast).map(RexSlot::getIndex).forEach(builder::set);
        relOptPredicateList.pulledUpPredicates.forEach(rex -> {
            if (rex.getKind() == SqlKind.EQUALS || rex.getKind() == SqlKind.IS_NOT_DISTINCT_FROM) {
                List<RexNode> ops = ((RexCall)rex).getOperands();
                RexNode op0 = ops.get(0);
                RexNode op1 = ops.get(1);
                RelMdColumnUniqueness.addInputRefIfOtherConstant(builder, op0, op1);
                RelMdColumnUniqueness.addInputRefIfOtherConstant(builder, op1, op0);
            }
        });
        return builder.build();
    }

    private static void addInputRefIfOtherConstant(ImmutableBitSet.Builder builder, RexNode inputRef, RexNode other) {
        if (inputRef instanceof RexInputRef && (other.getKind() == SqlKind.LITERAL || RelMdColumnUniqueness.isConstantScalarQuery(other))) {
            builder.set(((RexInputRef)inputRef).getIndex());
        }
    }

    private static boolean isConstantScalarQuery(RexNode rexNode) {
        if (rexNode.getKind() == SqlKind.SCALAR_QUERY) {
            final MutableBoolean hasCorrelatingVars = new MutableBoolean(false);
            ((RexSubQuery)rexNode).rel.accept(new RelShuttleImpl(){

                @Override
                public RelNode visit(LogicalFilter filter) {
                    if (RexUtil.containsCorrelation(filter.getCondition())) {
                        hasCorrelatingVars.setTrue();
                        return filter;
                    }
                    return super.visit(filter);
                }
            });
            return hasCorrelatingVars.isFalse();
        }
        return false;
    }
}

