/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.logit.storage.db;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.ignite.raft.jraft.storage.logit.storage.db.AbstractDB;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.FileType;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.index.IndexFile;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.index.IndexType;
import org.apache.ignite.raft.jraft.storage.logit.util.Pair;

public class IndexDB
extends AbstractDB {
    public IndexDB(String storePath, ScheduledExecutorService checkpointExecutor) {
        super(storePath, checkpointExecutor);
    }

    public Pair<Integer, Long> appendIndexAsync(long logIndex, int position, IndexType type) {
        long lastIndex = this.getLastLogIndex();
        if (lastIndex != -1L && logIndex != this.getLastLogIndex() + 1L) {
            return Pair.of(-1, -1L);
        }
        int waitToWroteSize = 10;
        IndexFile indexFile = (IndexFile)this.fileManager.getLastFile(logIndex, 10, true);
        if (indexFile != null) {
            int pos = indexFile.appendIndex(logIndex, position, type.getType());
            long expectFlushPosition = indexFile.getFileFromOffset() + (long)pos + 10L;
            return Pair.of(pos, expectFlushPosition);
        }
        return Pair.of(-1, -1L);
    }

    public Long appendBatchIndexAsync(List<IndexFile.IndexEntry> indexArray) {
        long maxFlushPosition = -1L;
        for (int i = 0; i < indexArray.size(); ++i) {
            IndexFile.IndexEntry index = indexArray.get(i);
            long logIndex = index.getLogIndex();
            if (logIndex != this.getLastLogIndex() + 1L) continue;
            Pair<Integer, Long> flushPair = this.appendIndexAsync(logIndex, index.getPosition(), index.getLogType() == 1 ? IndexType.IndexSegment : IndexType.IndexConf);
            maxFlushPosition = Math.max(maxFlushPosition, flushPair.getSecond());
        }
        return maxFlushPosition;
    }

    public IndexFile.IndexEntry lookupIndex(long logIndex) {
        IndexFile indexFile = (IndexFile)this.fileManager.findFileByLogIndex(logIndex, false);
        if (indexFile != null) {
            int indexPos = indexFile.calculateIndexPos(logIndex);
            long targetFlushPosition = indexFile.getFileFromOffset() + (long)indexPos;
            if (targetFlushPosition <= this.getFlushedPosition()) {
                return indexFile.lookupIndex(logIndex);
            }
        }
        return IndexFile.IndexEntry.newInstance();
    }

    public Pair<Integer, Integer> lookupFirstLogPosFromLogIndex(long logIndex) {
        long lastLogIndex = this.getLastLogIndex();
        int firstSegmentPos = -1;
        int firstConfPos = -1;
        for (long index = logIndex; index <= lastLogIndex; ++index) {
            IndexFile.IndexEntry indexEntry = this.lookupIndex(index);
            if (indexEntry.getLogType() == IndexType.IndexSegment.getType() && firstSegmentPos == -1) {
                firstSegmentPos = indexEntry.getPosition();
            } else if (indexEntry.getLogType() == IndexType.IndexConf.getType() && firstConfPos == -1) {
                firstConfPos = indexEntry.getPosition();
            }
            if (firstSegmentPos > 0 && firstConfPos > 0) break;
        }
        return Pair.of(firstSegmentPos, firstConfPos);
    }

    public Pair<IndexFile.IndexEntry, IndexFile.IndexEntry> lookupLastLogIndexAndPosFromTail() {
        long lastLogIndex = this.getLastLogIndex();
        long firstLogIndex = this.getFirstLogIndex();
        IndexFile.IndexEntry lastSegmentIndex = null;
        IndexFile.IndexEntry lastConfIndex = null;
        for (long index = lastLogIndex; index >= firstLogIndex; --index) {
            IndexFile.IndexEntry indexEntry = this.lookupIndex(index);
            indexEntry.setLogIndex(index);
            if (indexEntry.getLogType() == IndexType.IndexSegment.getType() && lastSegmentIndex == null) {
                lastSegmentIndex = indexEntry;
            } else if (indexEntry.getLogType() == IndexType.IndexConf.getType() && lastConfIndex == null) {
                lastConfIndex = indexEntry;
            }
            if (lastSegmentIndex != null && lastConfIndex != null) break;
        }
        return Pair.of(lastSegmentIndex, lastConfIndex);
    }

    @Override
    public FileType getDBFileType() {
        return FileType.FILE_INDEX;
    }

    @Override
    public int getDBFileSize() {
        return this.storeOptions.getIndexFileSize();
    }
}

