/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters.jmx;

import com.google.auto.service.AutoService;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.MetricProvider;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.exporters.BasicMetricExporter;
import org.apache.ignite.internal.metrics.exporters.MetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.internal.metrics.exporters.jmx.MetricSetMbean;
import org.apache.ignite.internal.util.IgniteUtils;

@AutoService(value={MetricExporter.class})
public class JmxExporter
extends BasicMetricExporter {
    public static final String JMX_EXPORTER_NAME = "jmx";
    private final IgniteLogger log;
    private final List<ObjectName> mbeans = new CopyOnWriteArrayList<ObjectName>();

    public JmxExporter() {
        this.log = Loggers.forClass(JmxExporter.class);
    }

    public JmxExporter(IgniteLogger log) {
        this.log = log;
    }

    @Override
    public void start(MetricProvider metricsProvider, ExporterView configuration, Supplier<UUID> clusterIdSupplier, String nodeName) {
        super.start(metricsProvider, configuration, clusterIdSupplier, nodeName);
        for (MetricSet metricSet : metricsProvider.snapshot().metrics().values()) {
            this.register(metricSet);
        }
    }

    @Override
    public void stop() {
        this.mbeans.forEach(this::unregBean);
        this.mbeans.clear();
    }

    @Override
    public String name() {
        return JMX_EXPORTER_NAME;
    }

    @Override
    public void reconfigure(ExporterView newValue) {
    }

    @Override
    public void addMetricSet(MetricSet metricSet) {
        this.register(metricSet);
    }

    @Override
    public void removeMetricSet(MetricSet metricSet) {
        this.unregister(metricSet);
    }

    private void register(MetricSet metricSet) {
        try {
            MetricSetMbean metricSetMbean = new MetricSetMbean(metricSet);
            ObjectName mbean = ManagementFactory.getPlatformMBeanServer().registerMBean(metricSetMbean, IgniteUtils.makeMbeanName((String)this.nodeName(), (String)metricSet.group(), (String)metricSet.name())).getObjectName();
            this.mbeans.add(mbean);
        }
        catch (JMException e) {
            this.log.error("MBean for metric set can't be created [name={}].", (Throwable)e, new Object[]{metricSet.name()});
        }
    }

    private void unregister(MetricSet metricSet) {
        try {
            ObjectName mbeanName = IgniteUtils.makeMbeanName((String)this.nodeName(), (String)metricSet.group(), (String)metricSet.name());
            boolean rmv = this.mbeans.remove(mbeanName);
            if (rmv) {
                this.unregBean(mbeanName);
            } else {
                this.log.warn("Tried to unregister the MBean for non-registered metric set [name={}].", new Object[]{metricSet.name()});
            }
        }
        catch (MalformedObjectNameException e) {
            this.log.error("MBean for metric set can't be unregistered [name={}].", (Throwable)e, new Object[]{metricSet.name()});
        }
    }

    private void unregBean(ObjectName bean) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(bean);
        }
        catch (JMException e) {
            this.log.error("Failed to unregister MBean [bean={}].", (Throwable)e, new Object[]{bean});
        }
    }
}

