/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.RenameTableCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.RenameIndexEntry;
import org.apache.ignite3.internal.catalog.storage.RenameTableEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;

public class RenameTableCommand
extends AbstractTableCommand {
    private final String newTableName;

    public static RenameTableCommandBuilder builder() {
        return new Builder();
    }

    private RenameTableCommand(String schemaName, String tableName, boolean ifExists, String newTableName) throws CatalogValidationException {
        super(schemaName, tableName, ifExists, true);
        CatalogParamsValidationUtils.validateIdentifier(newTableName, "New table name");
        this.newTableName = newTableName;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.newTableName);
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        String newPkIndexName = CatalogUtils.pkIndexName(this.newTableName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, newPkIndexName);
        CatalogIndexDescriptor pkIndex = CatalogUtils.indexOrThrow(catalog, table.primaryKeyIndexId());
        return List.of(new RenameTableEntry(table.id(), this.newTableName), new RenameIndexEntry(pkIndex.id(), newPkIndexName));
    }

    private static class Builder
    implements RenameTableCommandBuilder {
        private String schemaName;
        private String tableName;
        private boolean ifExists;
        private String newTableName;

        private Builder() {
        }

        @Override
        public RenameTableCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public RenameTableCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public RenameTableCommandBuilder ifTableExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public RenameTableCommandBuilder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new RenameTableCommand(this.schemaName, this.tableName, this.ifExists, this.newTableName);
        }
    }
}

