/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import org.apache.ignite3.internal.compute.ComputeMessagesFactory;
import org.apache.ignite3.internal.compute.message.JobStateResponse;
import org.apache.ignite3.internal.compute.message.JobStateResponseBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class JobStateResponseDeserializer
implements MessageDeserializer<JobStateResponse> {
    private final JobStateResponseBuilder msg;

    JobStateResponseDeserializer(ComputeMessagesFactory messageFactory) {
        this.msg = messageFactory.jobStateResponse();
    }

    @Override
    public Class<JobStateResponse> klass() {
        return JobStateResponse.class;
    }

    @Override
    public JobStateResponse getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("stateByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.stateByteArray(tmp);
                reader.incrementState();
            }
            case 1: {
                byte[] tmp = reader.readByteArray("throwableByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.throwableByteArray(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(JobStateResponse.class);
    }
}

