/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.message;

import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.message.HasDataRequest;
import org.apache.ignite3.internal.partition.replicator.network.message.HasDataRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.message.HasDataRequestSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class HasDataRequestImpl
implements HasDataRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final int partitionId;
    @IgniteToStringInclude
    private final int tableId;

    private HasDataRequestImpl(int partitionId, int tableId) {
        this.partitionId = partitionId;
        this.tableId = tableId;
    }

    @Override
    public int partitionId() {
        return this.partitionId;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return HasDataRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(HasDataRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HasDataRequestImpl otherMessage = (HasDataRequestImpl)other;
        return this.partitionId == otherMessage.partitionId && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.partitionId, this.tableId);
        return result;
    }

    @Override
    public HasDataRequestImpl clone() {
        try {
            return (HasDataRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HasDataRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements HasDataRequestBuilder {
        private int partitionId;
        private int tableId;

        private Builder() {
        }

        @Override
        public HasDataRequestBuilder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public HasDataRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public int partitionId() {
            return this.partitionId;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HasDataRequest build() {
            return new HasDataRequestImpl(this.partitionId, this.tableId);
        }
    }
}

