# 项目深度分析 Prompt

## 目标

根据指定的代码入口，深入分析完整的业务流程或功能实现，生成详细的技术和业务流程文档，便于团队成员理解、维护和协作。

## 关键规则

- **必须生成分析文档**：分析结果需保存到项目的 `docs/{module_name}/` 目录下。
- **必须使用思维链进行分析**：利用 `sequential-thinking` 或类似 mcp 工具辅助结构化思考。
- **必须深入代码逻辑**：不能停留在表面 API 调用，需深入理解函数/方法内部实现，必要时检索代码。

### 1. 聚焦核心逻辑

- **忽略非关键代码**：如日志打印、基础参数校验、标准的 getter/setter。
- **关注业务异常**：忽略通用的技术性异常处理（如网络错误、数据库连接失败），聚焦于业务规则导致的特定异常。
- **聚焦业务流程**：关注业务状态的流转、核心算法、关键决策分支和领域对象的处理。

### 2. 深入调用链

- **追踪关键调用**：追踪核心函数/方法的调用链，理解每一层的功能和职责。
- **分析外部依赖**：对于外部服务调用（如 RPC、REST API、数据库查询等），需说明其功能、业务上下文及对当前流程的影响。
- **剖析分支逻辑**：深入分析每个重要业务分支的触发条件和处理逻辑。

### 3. 结合已有文档

- **利用现有知识**：优先参考项目中已有的相关文档（如 README、设计文档、API 文档）。
- **引用和补充**：如果已有文档对某个模块或函数有清晰描述，可直接引用，并在此基础上补充更多实现细节。
- **识别不一致**：标注出文档与当前代码实现不一致的地方，为文档更新提供依据。

### 4. 文档输出规范

- **存储位置**：分析结果以 Markdown 格式保存到 `docs/{module_name}/` 目录下。
- **命名规范**：`README.md` 或 `业务名称-流程分析.md`。
- **结构清晰**：文档需包含清晰的调用树/图，展示调用层级关系。
- **流程化描述**：使用分步描述或流程图（如 Mermaid）来呈现完整的处理过程。

---

## 文档结构模板

````markdown
# [业务/功能名称] 详细分析

## 1. 功能概述

[简要描述该业务/功能的目标、范围和主要作用。]

## 2. 入口点

`[文件路径]:[函数/类名::方法名]`
_示例: `src/services/order_service.py:create_order`_

## 3. 函数/方法调用树

```
入口点
├─ 一级调用函数/方法 1
│ ├─ 二级调用函数/方法 1.1
│ └─ 二级调用函数/方法 1.2
├─ 一级调用函数/方法 2
  ├─ 二级调用函数/方法 2.1
  └─ 二级调用函数/方法 2.2
    └─ 三级调用函数/方法
```

## 4. 详细业务流程

1.  **[步骤 1]**: [描述此步骤的核心业务逻辑。]
2.  **[步骤 2]**: [描述此步骤的核心业务逻辑。]
    - **[子步骤 2.1]**: [更详细的逻辑拆解。]
    - **[子步骤 2.2]**: [更详细的逻辑拆解。]
3.  **[步骤 3]**: [描述此步骤的核心业务逻辑。]

## 5. 关键业务规则/逻辑

- **[规则 1]**: [描述一个核心业务规则及其判断条件。]
- **[规则 2]**: [描述一个核心业务规则及其判断条件。]

## 6. 数据流转

- **输入**: [描述入口接收的主要数据及其业务含义。]
- **核心处理**: [描述关键数据的转换、计算和状态变更。]
- **输出**: [描述最终返回的数据及其业务含义。]

## 7. 扩展点与分支逻辑

- **[分支 1]**: **触发条件**: [描述进入此分支的条件。] **处理逻辑**: [描述此分支的执行过程。]
- **[分支 2]**: **触发条件**: [描述进入此分支的条件。] **处理逻辑**: [描述此分支的执行过程。]

## 8. 外部依赖

- [列出对外部系统、服务或库的依赖，并说明其作用。例如：`[服务名/库名]: [依赖原因]`]

## 9. 注意事项

- [列出在实现、维护或使用此功能时需要特别注意的点。]

## 10. 系统交互图 (可选)

[如果业务流程涉及多个系统或模块，建议使用 Mermaid.js 等工具绘制时序图或流程图来可视化交互。]

```mermaid
flowchart TD
  A[Client] --&gt; B(API Gateway)
  B --&gt; C{Service A}
  C --&gt; D[Database]
```
````

---

## 代码分析技巧

### 步骤 1：明确分析起点

- **确定入口**：找到代码分析的起点，例如 API 路由处理函数、服务层入口、消息队列消费者、定时任务或主程序入口。
- **理解背景**：了解该入口的业务调用场景和前置条件。

### 步骤 2：构建调用关系

- **追踪调用链**：从入口点开始，递归追踪所有重要的函数/方法调用。
- **可视化层级**：使用缩进或图表（如调用树）来清晰地表示调用关系。
- **保持聚焦**：忽略与核心业务无关的调用（如通用工具函数）。

### 步骤 3：分析执行流程

- **顺序分析**：按照代码的实际执行顺序，逐步分析每个处理环节。
- **关注关键点**：重点关注业务状态的变更、关键算法和决策逻辑。
- **提取逻辑**：将复杂的代码块提炼为易于理解的业务或技术逻辑。

### 步骤 4：提炼业务规则

- **解读条件**：从 `if/else`, `switch`, `try/catch` 等条件判断中总结出隐含的业务规则。
- **识别场景**：分析不同场景（如用户角色、数据状态）下的处理差异。
- **明确决策**：提炼出业务流程中的核心决策点。

### 步骤 5：描述数据流动

- **追溯来源**：分析核心数据的来源。
- **观察处理**：理解数据在处理过程中的转换、聚合或修改。
- **明确去向**：了解数据的最终存储位置或返回给调用方。
- **关注实体**：关注核心业务实体（如 User, Order, Product）的状态变化。

## 优秀分析的特征

1.  **完整性**: 覆盖所有核心业务逻辑和主要分支。
2.  **层次性**: 清晰展示代码的结构和处理流程的层次。
3.  **业务导向**: 用业务语言描述功能，而不仅仅是复述代码。
4.  **精确性**: 准确反映代码的实际行为和逻辑。
5.  **可读性**: 使不熟悉代码的开发者甚至非技术人员（如产品经理）也能理解。
6.  **实用性**: 能够作为新人上手、代码重构、问题排查的有效参考。
