/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.WorkflowEventApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.workflow.EventLogRequest;
import org.apache.inlong.manager.pojo.workflow.EventLogResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowEventClient {
    private static final Logger log = LoggerFactory.getLogger(WorkflowEventClient.class);
    private final WorkflowEventApi workflowEventApi;

    public WorkflowEventClient(ClientConfiguration configuration) {
        this.workflowEventApi = (WorkflowEventApi)ClientUtils.createRetrofit(configuration).create(WorkflowEventApi.class);
    }

    public List<EventLogResponse> list(EventLogRequest request) {
        Map requestMap = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)request, (TypeReference)new TypeReference<Map<String, Object>>(){});
        requestMap.entrySet().removeIf(entry -> Objects.isNull(entry.getValue()));
        Response<PageResult<EventLogResponse>> response = ClientUtils.executeHttpCall(this.workflowEventApi.list(requestMap));
        ClientUtils.assertRespSuccess(response);
        return ((PageResult)response.getData()).getList();
    }

    public void executeEventListener(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"event id cannot be null");
        Response<Object> response = ClientUtils.executeHttpCall(this.workflowEventApi.executeEventListener(id));
        ClientUtils.assertRespSuccess(response);
    }

    public void executeProcessEventListener(Integer processId, String listenerName) {
        Preconditions.expectNotNull((Object)processId, (String)"processId cannot be null");
        Preconditions.expectNotBlank((String)listenerName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"listenerName cannot be null");
        Response<Object> response = ClientUtils.executeHttpCall(this.workflowEventApi.executeProcessEventListener(processId, listenerName));
        ClientUtils.assertRespSuccess(response);
    }

    public void executeTaskEventListener(Integer taskId, String listenerName) {
        Preconditions.expectNotNull((Object)taskId, (String)"taskId cannot be null");
        Preconditions.expectNotBlank((String)listenerName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"listenerName cannot be null");
        Response<Object> response = ClientUtils.executeHttpCall(this.workflowEventApi.executeTaskEventListener(taskId, listenerName));
        ClientUtils.assertRespSuccess(response);
    }

    public void triggerProcessEvent(Integer processId, ProcessEvent processEvent) {
        Preconditions.expectNotNull((Object)processId, (String)"processId cannot be null");
        Preconditions.expectNotNull((Object)processEvent, (String)"processEvent cannot be null");
        Response<Object> response = ClientUtils.executeHttpCall(this.workflowEventApi.triggerProcessEvent(processId, processEvent));
        ClientUtils.assertRespSuccess(response);
    }

    public void triggerTaskEvent(Integer processId, TaskEvent taskEvent) {
        Preconditions.expectNotNull((Object)processId, (String)"processId cannot be null");
        Preconditions.expectNotNull((Object)taskEvent, (String)"taskEvent cannot be null");
        Response<Object> response = ClientUtils.executeHttpCall(this.workflowEventApi.triggerTaskEvent(processId, taskEvent));
        ClientUtils.assertRespSuccess(response);
    }
}

