/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.stream;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateStreamCompleteListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateStreamCompleteListener.class);
    @Autowired
    private InlongStreamService streamService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        StreamStatus status;
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String operator = context.getOperator();
        GroupOperateType operateType = form.getGroupOperateType();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        switch (operateType) {
            case RESTART: {
                status = StreamStatus.CONFIG_SUCCESSFUL;
                break;
            }
            case SUSPEND: {
                status = StreamStatus.CONFIG_OFFLINE_SUCCESSFUL;
                break;
            }
            case DELETE: {
                status = StreamStatus.DELETED;
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unsupported operate=%s for inlong group", operateType));
            }
        }
        this.streamService.updateStatus(groupId, streamId, status.getCode(), operator);
        this.streamService.update(streamInfo.genRequest(), operator);
        return ListenerResult.success();
    }
}

