/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.sort.node.HttpNodeConfig;
import org.apache.inlong.common.pojo.sort.node.NodeConfig;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.http.HttpDataNodeDTO;
import org.apache.inlong.manager.pojo.node.http.HttpDataNodeInfo;
import org.apache.inlong.manager.pojo.node.http.HttpDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        HttpDataNodeRequest httpDataNodeRequest = (HttpDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)httpDataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            HttpDataNodeDTO dto = HttpDataNodeDTO.getFromRequest((HttpDataNodeRequest)httpDataNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Cloud log service node: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean accept(String dataNodeType) {
        return "HTTP".equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "HTTP";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        HttpDataNodeInfo info = new HttpDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)info);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            HttpDataNodeDTO dto = HttpDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)info);
        }
        return info;
    }

    @Override
    public NodeConfig getNodeConfig(DataNodeEntity dataNodeEntity) {
        DataNodeInfo dataNodeInfo = this.getFromEntity(dataNodeEntity);
        HttpNodeConfig httpNodeConfig = (HttpNodeConfig)CommonBeanUtils.copyProperties((Object)dataNodeInfo, HttpNodeConfig::new);
        HttpDataNodeDTO dto = HttpDataNodeDTO.getFromJson((String)dataNodeEntity.getExtParams());
        CommonBeanUtils.copyProperties((Object)dto, (Object)httpNodeConfig);
        httpNodeConfig.setPassword(dataNodeEntity.getToken());
        httpNodeConfig.setNodeName(dataNodeInfo.getName());
        return httpNodeConfig;
    }
}

