/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.logcollection.cos;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.ObjectMetadata;
import java.text.ParseException;
import java.util.List;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.plugin.task.logcollection.LogAbstractTask;
import org.apache.inlong.agent.plugin.task.logcollection.cos.FileScanner;
import org.apache.inlong.agent.plugin.utils.cos.COSUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSTask
extends LogAbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(COSTask.class);
    private String originPattern;
    private long lastScanTime = 0L;
    public final long SCAN_INTERVAL = 60000L;
    private COSClient cosClient;
    private String bucketName;
    private String secretId;
    private String secretKey;
    private String strRegion;

    @Override
    protected int getInstanceLimit() {
        return this.taskProfile.getInt("task.cosTask.maxFileCount");
    }

    @Override
    protected void initTask() {
        super.initTask();
        this.timeOffset = this.taskProfile.get("task.cosTask.timeOffset", "");
        this.retry = this.taskProfile.getBoolean("task.cosTask.retry", false);
        this.originPattern = this.taskProfile.get("task.cosTask.pattern");
        this.bucketName = this.taskProfile.get("task.cosTask.bucketName");
        this.secretId = this.taskProfile.get("task.cosTask.secretId");
        this.secretKey = this.taskProfile.get("task.cosTask.secretKey");
        this.strRegion = this.taskProfile.get("task.cosTask.region");
        this.cosClient = COSUtils.createCli(this.secretId, this.secretKey, this.strRegion);
        if (this.retry) {
            this.initRetryTask(this.taskProfile);
        }
    }

    private boolean initRetryTask(TaskProfile profile) {
        String dataTimeFrom = profile.get("task.cosTask.dataTimeFrom", "");
        String dataTimeTo = profile.get("task.cosTask.dataTimeTo", "");
        try {
            this.startTime = DateTransUtils.timeStrConvertToMillSec((String)dataTimeFrom, (String)profile.getCycleUnit());
            this.endTime = DateTransUtils.timeStrConvertToMillSec((String)dataTimeTo, (String)profile.getCycleUnit());
        }
        catch (ParseException e) {
            LOGGER.error("retry task time error start {} end {}", new Object[]{dataTimeFrom, dataTimeTo, e});
            return false;
        }
        return true;
    }

    public boolean isProfileValid(TaskProfile profile) {
        boolean ret;
        if (!profile.allRequiredKeyExist()) {
            LOGGER.error("task profile needs all required key");
            return false;
        }
        if (!profile.hasKey("task.cosTask.cycleUnit")) {
            LOGGER.error("task profile needs cos cycle unit");
            return false;
        }
        if (!profile.hasKey("task.cycleUnit")) {
            LOGGER.error("task profile needs cycle unit");
            return false;
        }
        if (profile.get("task.cycleUnit").compareTo(profile.get("task.cosTask.cycleUnit")) != 0) {
            LOGGER.error("task profile cycle unit must be consistent");
            return false;
        }
        if (!profile.hasKey("task.timeZone")) {
            LOGGER.error("task profile needs time zone");
            return false;
        }
        boolean bl = ret = profile.hasKey("task.cosTask.pattern") && profile.hasKey("task.cosTask.maxFileCount");
        if (!ret) {
            LOGGER.error("task profile needs file keys");
            return false;
        }
        if (!profile.hasKey("task.cosTask.timeOffset")) {
            LOGGER.error("task profile needs time offset");
            return false;
        }
        return !profile.getBoolean("task.cosTask.retry", false) || this.initRetryTask(profile);
    }

    @Override
    protected void releaseTask() {
        this.cosClient.shutdown();
    }

    @Override
    protected void runForNormal() {
        if (AgentUtils.getCurrentTime() - this.lastScanTime > 60000L) {
            this.scanExistingFile();
            this.lastScanTime = AgentUtils.getCurrentTime();
        }
        this.dealWithEventMap();
    }

    @Override
    protected void scanExistingFile() {
        List<FileScanner.BasicFileInfo> fileInfos = FileScanner.scanTaskBetweenTimes(this.cosClient, this.bucketName, this.originPattern, this.taskProfile.getCycleUnit(), this.timeOffset, this.startTime, this.endTime, this.retry);
        LOGGER.info("taskId {} scan {} get file count {}", new Object[]{this.getTaskId(), this.originPattern, fileInfos.size()});
        fileInfos.forEach(fileInfo -> {
            String fileName = fileInfo.fileName;
            String dataTime = fileInfo.dataTime;
            ObjectMetadata meta = this.cosClient.getObjectMetadata(this.bucketName, fileName);
            this.addToEvenMap(fileName, dataTime, meta.getLastModified().getTime(), this.taskProfile.getCycleUnit());
            if (this.retry) {
                ++this.instanceCount;
            }
        });
    }

    @Override
    protected void dealWithEventMap() {
        this.removeTimeoutEvent(this.eventMap, this.retry);
        this.dealWithEventMapWithCycle();
    }
}

