/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker;

import java.io.File;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.inlong.tubemq.corebase.config.TLSConfig;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fileconfig.ADConfig;
import org.apache.inlong.tubemq.server.common.fileconfig.AbstractFileConfig;
import org.apache.inlong.tubemq.server.common.fileconfig.PrometheusConfig;
import org.apache.inlong.tubemq.server.common.fileconfig.ZKConfig;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerConfig
extends AbstractFileConfig {
    static final long serialVersionUID = -1L;
    private static final Logger logger = LoggerFactory.getLogger(BrokerConfig.class);
    private int brokerId = 0;
    private String defEthName = "eth1";
    private String hostName;
    private int port = 8123;
    private int webPort = 8081;
    private String masterAddressList;
    private String primaryPath;
    private boolean enableWriteOffset2Zk = false;
    private String offsetStgFilePath;
    private long grpOffsetStgExpMs = 1728000000L;
    private long offsetStgCacheFlushMs = 5000L;
    private long offsetStgFileSyncMs = this.offsetStgCacheFlushMs + 1000L;
    private long offsetStgSyncDurWarnMs = 20000L;
    private int tcpWriteServiceThread = Runtime.getRuntime().availableProcessors() * 2;
    private int tcpReadServiceThread = Runtime.getRuntime().availableProcessors() * 2;
    private int tlsWriteServiceThread = Runtime.getRuntime().availableProcessors() * 2;
    private int tlsReadServiceThread = Runtime.getRuntime().availableProcessors() * 2;
    private long defaultDeduceReadSize = 0x1C0000000L;
    private long defaultDoubleDeduceReadSize = this.defaultDeduceReadSize * 2L;
    private int maxSegmentSize = 0x40000000;
    private int maxIndexSegmentSize = 19600000;
    private int transferSize = 524288;
    private int indexTransCount = 1000;
    private long rpcReadTimeoutMs = 10000L;
    private int consumerRegTimeoutMs = 30000;
    private boolean updateConsumerOffsets = true;
    private long heartbeatPeriodMs = 8000L;
    private long nettyWriteBufferHighWaterMark = 0xA00000L;
    private long nettyWriteBufferLowWaterMark = 0x500000L;
    private long logClearupDurationMs = 180000L;
    private long logFlushDiskDurMs = 20000L;
    private long logFlushMemDurMs = 10000L;
    private long socketSendBuffer = -1L;
    private long socketRecvBuffer = -1L;
    private int allowedReadIOExcptCnt = 3;
    private int allowedWriteIOExcptCnt = 3;
    private long visitTokenCheckInValidTimeMs = 120000L;
    private long ioExcptStatsDurationMs = 120000L;
    private int rowLockWaitDurMs = 30000;
    private ZKConfig zkConfig;
    private TLSConfig tlsConfig = new TLSConfig();
    private ADConfig auditConfig = null;
    private PrometheusConfig prometheusConfig = null;
    private boolean visitMasterAuth = false;
    private String visitName = "";
    private String visitPassword = "";
    private long authValidTimeStampPeriodMs = 20000L;
    private long groupOffsetScanDurMs = 60000L;
    private boolean enableMemStore = true;

    public boolean isEnableMemStore() {
        return this.enableMemStore;
    }

    public boolean isUpdateConsumerOffsets() {
        return this.updateConsumerOffsets;
    }

    public int getConsumerRegTimeoutMs() {
        return this.consumerRegTimeoutMs;
    }

    public long getHeartbeatPeriodMs() {
        return this.heartbeatPeriodMs;
    }

    public ZKConfig getZkConfig() {
        return this.zkConfig;
    }

    public TLSConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public ADConfig getAuditConfig() {
        return this.auditConfig;
    }

    public boolean isAuditEnable() {
        return this.auditConfig.isAuditEnable();
    }

    public PrometheusConfig getPrometheusConfig() {
        return this.prometheusConfig;
    }

    public boolean isPromEnable() {
        return this.prometheusConfig.isPromEnable();
    }

    public int getBrokerId() {
        if (this.brokerId <= 0) {
            try {
                this.brokerId = Math.abs(AddressUtils.ipToInt((String)AddressUtils.getIPV4LocalAddress((String)this.defEthName)));
            }
            catch (Exception e) {
                logger.error("Get brokerId error!", (Throwable)e);
            }
        }
        return this.brokerId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getRpcReadTimeoutMs() {
        return this.rpcReadTimeoutMs;
    }

    public int getMaxIndexSegmentSize() {
        return this.maxIndexSegmentSize;
    }

    public long getAuthValidTimeStampPeriodMs() {
        return this.authValidTimeStampPeriodMs;
    }

    public long getSocketSendBuffer() {
        return this.socketSendBuffer;
    }

    public long getSocketRecvBuffer() {
        return this.socketRecvBuffer;
    }

    public long getGroupOffsetScanDurMs() {
        return this.groupOffsetScanDurMs;
    }

    @Override
    protected void loadFileSectAttributes(Ini iniConf) {
        int promHttpPort;
        this.loadBrokerSectConf(iniConf);
        this.tlsConfig = this.loadTlsSectConf(iniConf, 8124);
        this.zkConfig = this.loadZKeeperSectConf(iniConf);
        this.auditConfig = this.loadAuditSectConf(iniConf);
        this.prometheusConfig = this.loadPrometheusSecConf(iniConf);
        if (this.port == this.webPort || this.tlsConfig.isTlsEnable() && this.tlsConfig.getTlsPort() == this.webPort) {
            throw new IllegalArgumentException(new StringBuilder(512).append("Illegal port value configuration, the value of ").append("port or tlsPort cannot be the same as the value of webPort!").toString());
        }
        if (this.prometheusConfig.isPromEnable() && ((promHttpPort = this.prometheusConfig.getPromHttpPort()) == this.port || promHttpPort == this.webPort || this.tlsConfig.isTlsEnable() && this.tlsConfig.getTlsPort() == promHttpPort)) {
            throw new IllegalArgumentException(new StringBuilder(512).append("Illegal port value configuration, the value of ").append("port or webPort or tlsPort cannot be the same as the value of promHttpPort!").toString());
        }
    }

    private void loadBrokerSectConf(Ini iniConf) {
        long tmpPeriodMs;
        Profile.Section brokerSect = (Profile.Section)iniConf.get((Object)"broker");
        if (brokerSect == null) {
            throw new IllegalArgumentException("Require broker section in configure file not Blank!");
        }
        this.brokerId = this.getInt(brokerSect, "brokerId");
        this.port = this.getInt(brokerSect, "port", 8123);
        if (TStringUtils.isBlank((String)((String)brokerSect.get((Object)"primaryPath")))) {
            throw new IllegalArgumentException("Require primaryPath not Blank!");
        }
        this.primaryPath = ((String)brokerSect.get((Object)"primaryPath")).trim();
        if (this.primaryPath.endsWith(File.separator)) {
            this.primaryPath = this.primaryPath.substring(0, this.primaryPath.length() - File.separator.length());
            if (this.primaryPath.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(256).append("Parameter primaryPath(").append(((String)brokerSect.get((Object)"primaryPath")).trim()).append(" only include separator! ").toString());
            }
        }
        if (TStringUtils.isBlank((String)((String)brokerSect.get((Object)"hostName")))) {
            throw new IllegalArgumentException(new StringBuilder(256).append("hostName is null or Blank in ").append("broker").append(" section!").toString());
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"enableWriteOffset2Zk")))) {
            this.enableWriteOffset2Zk = this.getBoolean(brokerSect, "enableWriteOffset2Zk");
        }
        if (TStringUtils.isBlank((String)((String)brokerSect.get((Object)"offsetStgFilePath")))) {
            this.offsetStgFilePath = this.primaryPath;
        } else {
            this.offsetStgFilePath = ((String)brokerSect.get((Object)"offsetStgFilePath")).trim();
            if (this.offsetStgFilePath.endsWith(File.separator)) {
                this.offsetStgFilePath = this.offsetStgFilePath.substring(0, this.offsetStgFilePath.length() - File.separator.length());
                if (this.offsetStgFilePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(256).append("Parameter offsetStgFilePath(").append(((String)brokerSect.get((Object)"offsetStgFilePath")).trim()).append(" only include separator! ").toString());
                }
            }
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"offsetStgCacheFlushMs")))) {
            this.offsetStgCacheFlushMs = Math.min(this.getLong(brokerSect, "offsetStgCacheFlushMs"), 1000L);
            this.offsetStgFileSyncMs = this.offsetStgCacheFlushMs + 1000L;
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"grpOffsetStgExpMs")))) {
            this.grpOffsetStgExpMs = Math.min(this.getLong(brokerSect, "grpOffsetStgExpMs"), 86400000L);
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"offsetStgFileSyncMs")))) {
            this.offsetStgFileSyncMs = Math.min(this.getLong(brokerSect, "offsetStgFileSyncMs"), this.offsetStgCacheFlushMs + 1000L);
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"offsetStgSyncDurWarnMs")))) {
            this.offsetStgSyncDurWarnMs = Math.min(this.getLong(brokerSect, "offsetStgSyncDurWarnMs"), this.offsetStgFileSyncMs + 1000L);
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"defEthName")))) {
            this.defEthName = ((String)brokerSect.get((Object)"defEthName")).trim();
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"hostName")))) {
            this.hostName = ((String)brokerSect.get((Object)"hostName")).trim();
        } else {
            try {
                this.hostName = AddressUtils.getIPV4LocalAddress((String)this.defEthName);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(new StringBuilder(256).append("Get default broker hostName failure : ").append(e.getMessage()).toString());
            }
        }
        if (TStringUtils.isBlank((String)((String)brokerSect.get((Object)"masterAddressList")))) {
            throw new IllegalArgumentException(new StringBuilder(256).append("masterAddressList is null or Blank in ").append("broker").append(" section!").toString());
        }
        this.masterAddressList = (String)brokerSect.get((Object)"masterAddressList");
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"webPort")))) {
            this.webPort = this.getInt(brokerSect, "webPort");
        }
        this.maxSegmentSize = this.getInt(brokerSect, "maxSegmentSize");
        this.transferSize = this.getInt(brokerSect, "transferSize");
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"indexTransCount")))) {
            this.indexTransCount = this.getInt(brokerSect, "indexTransCount");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"logClearupDurationMs")))) {
            this.logClearupDurationMs = this.getLong(brokerSect, "logClearupDurationMs");
            if (this.logClearupDurationMs < 60000L) {
                this.logClearupDurationMs = 60000L;
            }
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"logFlushDiskDurMs")))) {
            this.logFlushDiskDurMs = this.getLong(brokerSect, "logFlushDiskDurMs");
            if (this.logFlushDiskDurMs < 10000L) {
                this.logFlushDiskDurMs = 10000L;
            }
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"logFlushMemDurMs")))) {
            this.logFlushMemDurMs = this.getLong(brokerSect, "logFlushMemDurMs");
            if (this.logFlushMemDurMs < 10000L) {
                this.logFlushMemDurMs = 10000L;
            }
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"authValidTimeStampPeriodMs")))) {
            tmpPeriodMs = this.getLong(brokerSect, "authValidTimeStampPeriodMs");
            long l = tmpPeriodMs < 5000L ? 5000L : (this.authValidTimeStampPeriodMs = tmpPeriodMs > 120000L ? 120000L : tmpPeriodMs);
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"visitTokenCheckInValidTimeMs")))) {
            tmpPeriodMs = this.getLong(brokerSect, "visitTokenCheckInValidTimeMs");
            long l = tmpPeriodMs < 60000L ? 60000L : (this.visitTokenCheckInValidTimeMs = tmpPeriodMs > 300000L ? 300000L : tmpPeriodMs);
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"socketSendBuffer")))) {
            this.socketSendBuffer = this.getLong(brokerSect, "socketSendBuffer");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"socketRecvBuffer")))) {
            this.socketRecvBuffer = this.getLong(brokerSect, "socketRecvBuffer");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"maxIndexSegmentSize")))) {
            this.maxIndexSegmentSize = this.getInt(brokerSect, "maxIndexSegmentSize");
        }
        if (!TStringUtils.isBlank((String)((String)brokerSect.get((Object)"updateConsumerOffsets")))) {
            this.updateConsumerOffsets = this.getBoolean(brokerSect, "updateConsumerOffsets");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"rpcReadTimeoutMs")))) {
            this.rpcReadTimeoutMs = this.getLong(brokerSect, "rpcReadTimeoutMs");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"nettyWriteBufferHighWaterMark")))) {
            this.nettyWriteBufferHighWaterMark = this.getLong(brokerSect, "nettyWriteBufferHighWaterMark");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"nettyWriteBufferLowWaterMark")))) {
            this.nettyWriteBufferLowWaterMark = this.getLong(brokerSect, "nettyWriteBufferLowWaterMark");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"heartbeatPeriodMs")))) {
            this.heartbeatPeriodMs = this.getLong(brokerSect, "heartbeatPeriodMs");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"tcpWriteServiceThread")))) {
            this.tcpWriteServiceThread = this.getInt(brokerSect, "tcpWriteServiceThread");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"tcpReadServiceThread")))) {
            this.tcpReadServiceThread = this.getInt(brokerSect, "tcpReadServiceThread");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"tlsWriteServiceThread")))) {
            this.tlsWriteServiceThread = this.getInt(brokerSect, "tlsWriteServiceThread");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"tlsReadServiceThread")))) {
            this.tlsReadServiceThread = this.getInt(brokerSect, "tlsReadServiceThread");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"consumerRegTimeoutMs")))) {
            this.consumerRegTimeoutMs = this.getInt(brokerSect, "consumerRegTimeoutMs");
            if (this.consumerRegTimeoutMs < 20000) {
                this.consumerRegTimeoutMs = 20000;
            }
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"defaultDeduceReadSize")))) {
            this.defaultDeduceReadSize = this.getLong(brokerSect, "defaultDeduceReadSize");
            this.defaultDoubleDeduceReadSize = this.defaultDeduceReadSize * 2L;
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"rowLockWaitDurMs")))) {
            this.rowLockWaitDurMs = this.getInt(brokerSect, "rowLockWaitDurMs");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"allowedReadIOExcptCnt")))) {
            this.allowedReadIOExcptCnt = this.getInt(brokerSect, "allowedReadIOExcptCnt");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"allowedWriteIOExcptCnt")))) {
            this.allowedWriteIOExcptCnt = this.getInt(brokerSect, "allowedWriteIOExcptCnt");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"ioExcptStatsDurationMs")))) {
            this.ioExcptStatsDurationMs = this.getLong(brokerSect, "ioExcptStatsDurationMs");
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"visitMasterAuth")))) {
            this.visitMasterAuth = this.getBoolean(brokerSect, "visitMasterAuth");
        }
        if (this.visitMasterAuth) {
            if (TStringUtils.isBlank((String)((String)brokerSect.get((Object)"visitName")))) {
                throw new IllegalArgumentException(new StringBuilder(256).append("visitName is null or Blank in ").append("broker").append(" section!").toString());
            }
            if (TStringUtils.isBlank((String)((String)brokerSect.get((Object)"visitPassword")))) {
                throw new IllegalArgumentException(new StringBuilder(256).append("visitPassword is null or Blank in ").append("broker").append(" section!").toString());
            }
            this.visitName = ((String)brokerSect.get((Object)"visitName")).trim();
            this.visitPassword = ((String)brokerSect.get((Object)"visitPassword")).trim();
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"groupOffsetScanDurMs")))) {
            this.groupOffsetScanDurMs = MixedUtils.mid((long)this.getLong(brokerSect, "groupOffsetScanDurMs"), (long)20000L, (long)480000L);
        }
        if (TStringUtils.isNotBlank((String)((String)brokerSect.get((Object)"enableMemStore")))) {
            this.enableMemStore = this.getBoolean(brokerSect, "enableMemStore");
        }
    }

    public long getLogClearupDurationMs() {
        return this.logClearupDurationMs;
    }

    public long getLogFlushDiskDurMs() {
        return this.logFlushDiskDurMs;
    }

    public long getLogFlushMemDurMs() {
        return this.logFlushMemDurMs;
    }

    public boolean isTlsEnable() {
        return this.tlsConfig.isTlsEnable();
    }

    public int getTlsPort() {
        return this.tlsConfig.getTlsPort();
    }

    public long getIoExcptStatsDurationMs() {
        return this.ioExcptStatsDurationMs;
    }

    public int getAllowedWriteIOExcptCnt() {
        return this.allowedWriteIOExcptCnt;
    }

    public int getAllowedReadIOExcptCnt() {
        return this.allowedReadIOExcptCnt;
    }

    public int getRowLockWaitDurMs() {
        return this.rowLockWaitDurMs;
    }

    public int getPort() {
        return this.port;
    }

    public long getVisitTokenCheckInValidTimeMs() {
        return this.visitTokenCheckInValidTimeMs;
    }

    public int getTcpWriteServiceThread() {
        return this.tcpWriteServiceThread;
    }

    public int getTlsWriteServiceThread() {
        return this.tlsWriteServiceThread;
    }

    public int getTlsReadServiceThread() {
        return this.tlsReadServiceThread;
    }

    public long getDefaultDeduceReadSize() {
        return this.defaultDeduceReadSize;
    }

    public long getDoubleDefaultDeduceReadSize() {
        return this.defaultDoubleDeduceReadSize;
    }

    public int getTcpReadServiceThread() {
        return this.tcpReadServiceThread;
    }

    public int getTransferSize() {
        return this.transferSize;
    }

    public int getIndexTransCount() {
        return this.indexTransCount;
    }

    public int getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    public long getNettyWriteBufferLowWaterMark() {
        return this.nettyWriteBufferLowWaterMark;
    }

    public long getNettyWriteBufferHighWaterMark() {
        return this.nettyWriteBufferHighWaterMark;
    }

    public boolean isVisitMasterAuth() {
        return this.visitMasterAuth;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public String getVisitPassword() {
        return this.visitPassword;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String getPrimaryPath() {
        return this.primaryPath;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public String getMasterAddressList() {
        return this.masterAddressList;
    }

    public boolean isEnableWriteOffset2Zk() {
        return this.enableWriteOffset2Zk;
    }

    public String getOffsetStgFilePath() {
        return this.offsetStgFilePath;
    }

    public long getGrpOffsetStgExpMs() {
        return this.grpOffsetStgExpMs;
    }

    public long getOffsetStgCacheFlushMs() {
        return this.offsetStgCacheFlushMs;
    }

    public long getOffsetStgFileSyncMs() {
        return this.offsetStgFileSyncMs;
    }

    public long getOffsetStgSyncDurWarnMs() {
        return this.offsetStgSyncDurWarnMs;
    }
}

