/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.TopicProcessResult;

public class WebTopicCtrlHandler
extends AbstractWebHandler {
    public WebTopicCtrlHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_topic_control_info", "adminQueryTopicCtrlInfo");
        this.registerModifyWebMethod("admin_add_topic_control_info", "adminAddTopicCtrlInfo");
        this.registerModifyWebMethod("admin_batch_add_topic_control_info", "adminBatchAddTopicCtrlInfo");
        this.registerModifyWebMethod("admin_update_topic_control_info", "adminModTopicCtrlInfo");
        this.registerModifyWebMethod("admin_batch_update_topic_control_info", "adminBatchModTopicCtrlInfo");
        this.registerModifyWebMethod("admin_delete_topic_control_info", "adminDeleteTopicCtrlInfo");
    }

    public StringBuilder adminQueryTopicCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        TopicCtrlEntity qryEntity = new TopicCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        Map<String, TopicCtrlEntity> topicCtrlMap = this.defMetaDataService.getTopicCtrlConf(topicNameSet, qryEntity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (TopicCtrlEntity entity : topicCtrlMap.values()) {
            if (entity == null) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            entity.toWebJsonStr(sBuffer, true, true);
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminAddTopicCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdTopicCtrlInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminBatchAddTopicCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdTopicCtrlInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminModTopicCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdTopicCtrlInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminBatchModTopicCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdTopicCtrlInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminDeleteTopicCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        ArrayList<TopicProcessResult> retInfo = new ArrayList<TopicProcessResult>();
        for (String topicName : topicNameSet) {
            this.defMetaDataService.delTopicCtrlConf(opEntity.getModifyUser(), topicName, sBuffer, result);
            retInfo.add(new TopicProcessResult(-2, topicName, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private StringBuilder innAddOrUpdTopicCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        int topicNameId = -2;
        if (topicNameSet.size() == 1) {
            if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.TOPICNAMEID, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return sBuffer;
            }
            topicNameId = (Integer)result.getRetData();
        }
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.AUTHCTRLENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus enableTopicAuth = (EnableStatus)((Object)result.getRetData());
        ClusterSettingEntity defClusterSetting = this.defMetaDataService.getClusterDefSetting(false);
        int maxMsgSizeMB = defClusterSetting.getMaxMsgSizeInMB();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.MAXMSGSIZEINMB, false, isAddOp ? maxMsgSizeMB : -2, 1, 20, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        maxMsgSizeMB = (Integer)result.getRetData();
        List<TopicProcessResult> retInfo = this.defMetaDataService.addOrUpdTopicCtrlConf(isAddOp, opEntity, topicNameSet, topicNameId, enableTopicAuth, maxMsgSizeMB, sBuffer, result);
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private StringBuilder innBatchAddOrUpdTopicCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity defOpEntity = (BaseEntity)result.getRetData();
        if (!this.getTopicCtrlJsonSetInfo(req, isAddOp, defOpEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        List<TopicProcessResult> retInfo = this.defMetaDataService.addOrUpdTopicCtrlConf(isAddOp, addRecordMap, sBuffer, result);
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private boolean getTopicCtrlJsonSetInfo(HttpServletRequest req, boolean isAddOp, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.TOPICCTRLSET, true, null, result)) {
            return result.isSuccess();
        }
        List ctrlJsonArray = (List)result.getRetData();
        ClusterSettingEntity defClusterSetting = this.defMetaDataService.getClusterDefSetting(false);
        int defMaxMsgSizeMB = defClusterSetting.getMaxMsgSizeInMB();
        HashMap<String, TopicCtrlEntity> addRecordMap = new HashMap<String, TopicCtrlEntity>();
        for (Map itemConfMap : ctrlJsonArray) {
            if (!WebParameterUtils.getAUDBaseInfo(itemConfMap, isAddOp, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemConfMap, WebFieldDef.TOPICNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String topicName = (String)result.getRetData();
            if (!WebParameterUtils.getIntParamValue(itemConfMap, WebFieldDef.MAXMSGSIZEINMB, false, isAddOp ? defMaxMsgSizeMB : -2, 1, 20, sBuffer, result)) {
                return result.isSuccess();
            }
            int itemMaxMsgSizeMB = (Integer)result.getRetData();
            if (!WebParameterUtils.getIntParamValue(itemConfMap, WebFieldDef.TOPICNAMEID, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
                return result.isSuccess();
            }
            int itemTopicNameId = (Integer)result.getRetData();
            if (!WebParameterUtils.getEnableStatusValue(itemConfMap, WebFieldDef.AUTHCTRLENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
                return result.isSuccess();
            }
            EnableStatus enableTopicAuth = (EnableStatus)((Object)result.getRetData());
            TopicCtrlEntity itemConf = new TopicCtrlEntity(itemOpEntity, topicName);
            itemConf.updModifyInfo(itemOpEntity.getDataVerId(), itemTopicNameId, itemMaxMsgSizeMB, enableTopicAuth);
            addRecordMap.put(itemConf.getTopicName(), itemConf);
        }
        if (addRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record info in ").append(WebFieldDef.TOPICCTRLSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addRecordMap);
        return result.isSuccess();
    }

    private StringBuilder buildRetInfo(List<TopicProcessResult> retInfo, StringBuilder sBuffer) {
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (TopicProcessResult entry : retInfo) {
            if (entry == null) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"topicName\":\"").append(entry.getTopicName()).append("\"").append(",\"success\":").append(entry.isSuccess()).append(",\"errCode\":").append(entry.getErrCode()).append(",\"errInfo\":\"").append(entry.getErrMsg()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }
}

