/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import java.net.InetSocketAddress;
import java.util.HashSet;

public class BdbGroupAdmin {
    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 3) {
            System.out.println("Parameter error. Need 3 params : \n1) replication group name,\n2) replication group helperHost(ip:port),\n3) node name in replication group to be removed.");
            return;
        }
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>();
        String group = args[0];
        String[] hostAndPort = args[1].split(":");
        if (hostAndPort.length != 2) {
            System.out.println("replication group helperHost(ip:port) format error.");
            return;
        }
        String nodeName2Remove = args[2];
        InetSocketAddress helper = new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
        helpers.add(helper);
        ReplicationGroupAdmin rga = new ReplicationGroupAdmin(group, helpers);
        try {
            HashSet<String> nodeNames = new HashSet<String>();
            for (ReplicationNode repNode : rga.getGroup().getNodes()) {
                nodeNames.add(repNode.getName());
            }
            System.out.println("Before remove, " + group + " has " + nodeNames.size() + " nodes :" + nodeNames);
            rga.removeMember(nodeName2Remove);
            System.out.print("Remove " + nodeName2Remove + "successfully.");
            nodeNames.clear();
            for (ReplicationNode repNode : rga.getGroup().getNodes()) {
                nodeNames.add(repNode.getName());
            }
            System.out.println("After remove, " + group + " has " + nodeNames.size() + " nodes :" + nodeNames);
        }
        catch (UnknownMasterException e) {
            System.out.println("Can't find active master node.");
        }
        catch (MemberNotFoundException e) {
            System.out.println("Node name to remove is unknown to the replication group, please use the correct node name.");
        }
        catch (MasterStateException e) {
            System.out.println("Master node is not allowed to remove. To remove the active Master, either shut it down or wait until it transitions to the Replica state.");
        }
        catch (EnvironmentFailureException e) {
            System.out.println("Replication group environment failed.");
        }
    }
}

