/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.inlong.common.metric.MetricItemValue;
import org.apache.inlong.common.metric.MetricListener;
import org.apache.inlong.common.metric.MetricValue;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricListener
extends Collector
implements MetricListener {
    public static final String DEFAULT_DIMENSION_LABEL = "dimension";
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusMetricListener.class);
    protected HTTPServer httpServer;
    private String metricName;
    private DataProxyMetricItem metricItem;
    private Map<String, AtomicLong> metricValueMap = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, MetricItemValue> dimensionMetricValueMap = new ConcurrentHashMap<String, MetricItemValue>();
    private List<String> dimensionKeys = new ArrayList<String>();

    public PrometheusMetricListener() {
        this.metricName = CommonConfigHolder.getInstance().getClusterName();
        this.metricItem = new DataProxyMetricItem();
        this.metricItem.clusterId = this.metricName;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        StringBuilder beanName = new StringBuilder();
        beanName.append("org.apache.inlong").append(':').append("type=DataProxyPrometheus");
        String strBeanName = beanName.toString();
        try {
            ObjectName objName = new ObjectName(strBeanName);
            mbs.registerMBean((Object)this.metricItem, objName);
        }
        catch (Exception ex) {
            LOG.error("exception while register mbean:{},error:{}", (Object)strBeanName, (Object)ex);
        }
        this.metricValueMap.put("readSuccessCount", this.metricItem.readSuccessCount);
        this.metricValueMap.put("readSuccessSize", this.metricItem.readSuccessSize);
        this.metricValueMap.put("readFailCount", this.metricItem.readFailCount);
        this.metricValueMap.put("readFailSize", this.metricItem.readFailSize);
        this.metricValueMap.put("sendCount", this.metricItem.sendCount);
        this.metricValueMap.put("sendSize", this.metricItem.sendSize);
        this.metricValueMap.put("sendSuccessCount", this.metricItem.sendSuccessCount);
        this.metricValueMap.put("sendSuccessSize", this.metricItem.sendSuccessSize);
        this.metricValueMap.put("sendFailCount", this.metricItem.sendFailCount);
        this.metricValueMap.put("sendFailSize", this.metricItem.sendFailSize);
        this.metricValueMap.put("sinkDuration", this.metricItem.sinkDuration);
        this.metricValueMap.put("nodeDuration", this.metricItem.nodeDuration);
        this.metricValueMap.put("wholeDuration", this.metricItem.wholeDuration);
        try {
            this.httpServer = new HTTPServer(CommonConfigHolder.getInstance().getPrometheusHttpPort());
            this.register();
        }
        catch (IOException e) {
            LOG.error("exception while register prometheus http server:{},error:{}", (Object)this.metricName, (Object)e.getMessage());
        }
    }

    public void snapshot(String domain, List<MetricItemValue> itemValues) {
        for (MetricItemValue itemValue : itemValues) {
            for (Map.Entry entry : itemValue.getMetrics().entrySet()) {
                String fieldName = ((MetricValue)entry.getValue()).name;
                AtomicLong metricValue = this.metricValueMap.get(fieldName);
                if (metricValue == null) continue;
                long fieldValue = ((MetricValue)entry.getValue()).value;
                metricValue.addAndGet(fieldValue);
            }
            String dimensionKey = itemValue.getKey();
            MetricItemValue dimensionMetricValue = this.dimensionMetricValueMap.get(dimensionKey);
            if (dimensionMetricValue == null) {
                dimensionMetricValue = new MetricItemValue(dimensionKey, new ConcurrentHashMap(), new ConcurrentHashMap());
                this.dimensionMetricValueMap.putIfAbsent(dimensionKey, dimensionMetricValue);
                dimensionMetricValue = this.dimensionMetricValueMap.get(dimensionKey);
                dimensionMetricValue.getDimensions().putAll(itemValue.getDimensions());
                for (Map.Entry entry : itemValue.getDimensions().entrySet()) {
                    if (this.dimensionKeys.contains(entry.getKey())) continue;
                    this.dimensionKeys.add((String)entry.getKey());
                }
            }
            for (Map.Entry entry : itemValue.getMetrics().entrySet()) {
                String fieldName = ((MetricValue)entry.getValue()).name;
                MetricValue metricValue = (MetricValue)dimensionMetricValue.getMetrics().get(fieldName);
                if (metricValue == null) {
                    metricValue = MetricValue.of((String)fieldName, (long)((MetricValue)entry.getValue()).value);
                    dimensionMetricValue.getMetrics().put(metricValue.name, metricValue);
                    continue;
                }
                metricValue.value += ((MetricValue)entry.getValue()).value;
            }
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        CounterMetricFamily totalCounter = new CounterMetricFamily(this.metricName, "The metrics of dataproxy node.", Arrays.asList(DEFAULT_DIMENSION_LABEL));
        totalCounter.addMetric(Arrays.asList("readSuccessCount"), (double)this.metricItem.readSuccessCount.get());
        totalCounter.addMetric(Arrays.asList("readSuccessSize"), (double)this.metricItem.readSuccessSize.get());
        totalCounter.addMetric(Arrays.asList("readFailCount"), (double)this.metricItem.readFailCount.get());
        totalCounter.addMetric(Arrays.asList("readFailSize"), (double)this.metricItem.readFailSize.get());
        totalCounter.addMetric(Arrays.asList("sendCount"), (double)this.metricItem.sendCount.get());
        totalCounter.addMetric(Arrays.asList("sendSize"), (double)this.metricItem.sendSize.get());
        totalCounter.addMetric(Arrays.asList("sendSuccessCount"), (double)this.metricItem.sendSuccessCount.get());
        totalCounter.addMetric(Arrays.asList("sendSuccessSize"), (double)this.metricItem.sendSuccessSize.get());
        totalCounter.addMetric(Arrays.asList("sendFailCount"), (double)this.metricItem.sendFailCount.get());
        totalCounter.addMetric(Arrays.asList("sendFailSize"), (double)this.metricItem.sendFailSize.get());
        totalCounter.addMetric(Arrays.asList("sinkDuration"), (double)this.metricItem.sinkDuration.get());
        totalCounter.addMetric(Arrays.asList("nodeDuration"), (double)this.metricItem.nodeDuration.get());
        totalCounter.addMetric(Arrays.asList("wholeDuration"), (double)this.metricItem.wholeDuration.get());
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        mfs.add((Collector.MetricFamilySamples)totalCounter);
        ArrayList<String> dimensionIdKeys = new ArrayList<String>();
        dimensionIdKeys.add(DEFAULT_DIMENSION_LABEL);
        dimensionIdKeys.addAll(this.dimensionKeys);
        CounterMetricFamily idCounter = new CounterMetricFamily(this.metricName + "_id", "The metrics of inlong datastream.", dimensionIdKeys);
        for (Map.Entry<String, MetricItemValue> entry : this.dimensionMetricValueMap.entrySet()) {
            MetricItemValue itemValue = entry.getValue();
            this.addCounterMetricFamily("readSuccessCount", itemValue, idCounter);
            this.addCounterMetricFamily("readSuccessSize", itemValue, idCounter);
            this.addCounterMetricFamily("readFailCount", itemValue, idCounter);
            this.addCounterMetricFamily("readFailSize", itemValue, idCounter);
            this.addCounterMetricFamily("sendCount", itemValue, idCounter);
            this.addCounterMetricFamily("sendSize", itemValue, idCounter);
            this.addCounterMetricFamily("sendSuccessCount", itemValue, idCounter);
            this.addCounterMetricFamily("sendSuccessSize", itemValue, idCounter);
            this.addCounterMetricFamily("sendFailCount", itemValue, idCounter);
            this.addCounterMetricFamily("sendFailSize", itemValue, idCounter);
            this.addCounterMetricFamily("sinkDuration", itemValue, idCounter);
            this.addCounterMetricFamily("nodeDuration", itemValue, idCounter);
            this.addCounterMetricFamily("wholeDuration", itemValue, idCounter);
        }
        mfs.add((Collector.MetricFamilySamples)idCounter);
        return mfs;
    }

    private void addCounterMetricFamily(String defaultDemension, MetricItemValue itemValue, CounterMetricFamily idCounter) {
        ArrayList<String> labelValues = new ArrayList<String>(this.dimensionKeys.size());
        labelValues.add(defaultDemension);
        Map dimensions = itemValue.getDimensions();
        for (String key : this.dimensionKeys) {
            String labelValue = dimensions.getOrDefault(key, "-");
            labelValues.add(labelValue);
        }
        long value = 0L;
        Map metricValueMap = itemValue.getMetrics();
        MetricValue metricValue = (MetricValue)metricValueMap.get(defaultDemension);
        if (metricValue != null) {
            value = metricValue.value;
        }
        idCounter.addMetric(labelValues, (double)value);
    }
}

