/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.kudu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.kudu.KuduDataNodeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="Kudu data node info")
public class KuduDataNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(KuduDataNodeDTO.class);
    @ApiModelProperty(value="Kudu masters, a comma separated list of 'host:port' pairs")
    private String masters;
    @ApiModelProperty(value="Sets the default timeout used for administrative operations (e.g. createTable, deleteTable, etc). Optional. If not provided, defaults to 30s. A value of 0 disables the timeout")
    private Integer defaultAdminOperationTimeoutMs;
    @ApiModelProperty(value="Sets the default timeout used for user operations (using sessions and scanners). Optional. If not provided, defaults to 30s. A value of 0 disables the timeout")
    private Integer defaultOperationTimeoutMs = 30000;
    @ApiModelProperty(value="Default socket read timeout in ms, default is 10000")
    private Integer defaultSocketReadTimeoutMs = 10000;
    @ApiModelProperty(value="Disable this client's collection of statistics. Statistics are enabled by default")
    private Boolean statisticsDisabled = false;

    public static KuduDataNodeDTO getFromRequest(KuduDataNodeRequest request, String extParams) {
        KuduDataNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? KuduDataNodeDTO.getFromJson(extParams) : new KuduDataNodeDTO();
        return (KuduDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static KuduDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (KuduDataNodeDTO)JsonUtils.parseObject((String)extParams, KuduDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("Failed to parse extParams for Kudu node: %s", e.getMessage()));
        }
    }

    public static KuduDataNodeDTOBuilder builder() {
        return new KuduDataNodeDTOBuilder();
    }

    public String getMasters() {
        return this.masters;
    }

    public Integer getDefaultAdminOperationTimeoutMs() {
        return this.defaultAdminOperationTimeoutMs;
    }

    public Integer getDefaultOperationTimeoutMs() {
        return this.defaultOperationTimeoutMs;
    }

    public Integer getDefaultSocketReadTimeoutMs() {
        return this.defaultSocketReadTimeoutMs;
    }

    public Boolean getStatisticsDisabled() {
        return this.statisticsDisabled;
    }

    public void setMasters(String masters) {
        this.masters = masters;
    }

    public void setDefaultAdminOperationTimeoutMs(Integer defaultAdminOperationTimeoutMs) {
        this.defaultAdminOperationTimeoutMs = defaultAdminOperationTimeoutMs;
    }

    public void setDefaultOperationTimeoutMs(Integer defaultOperationTimeoutMs) {
        this.defaultOperationTimeoutMs = defaultOperationTimeoutMs;
    }

    public void setDefaultSocketReadTimeoutMs(Integer defaultSocketReadTimeoutMs) {
        this.defaultSocketReadTimeoutMs = defaultSocketReadTimeoutMs;
    }

    public void setStatisticsDisabled(Boolean statisticsDisabled) {
        this.statisticsDisabled = statisticsDisabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KuduDataNodeDTO)) {
            return false;
        }
        KuduDataNodeDTO other = (KuduDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$defaultAdminOperationTimeoutMs = this.getDefaultAdminOperationTimeoutMs();
        Integer other$defaultAdminOperationTimeoutMs = other.getDefaultAdminOperationTimeoutMs();
        if (this$defaultAdminOperationTimeoutMs == null ? other$defaultAdminOperationTimeoutMs != null : !((Object)this$defaultAdminOperationTimeoutMs).equals(other$defaultAdminOperationTimeoutMs)) {
            return false;
        }
        Integer this$defaultOperationTimeoutMs = this.getDefaultOperationTimeoutMs();
        Integer other$defaultOperationTimeoutMs = other.getDefaultOperationTimeoutMs();
        if (this$defaultOperationTimeoutMs == null ? other$defaultOperationTimeoutMs != null : !((Object)this$defaultOperationTimeoutMs).equals(other$defaultOperationTimeoutMs)) {
            return false;
        }
        Integer this$defaultSocketReadTimeoutMs = this.getDefaultSocketReadTimeoutMs();
        Integer other$defaultSocketReadTimeoutMs = other.getDefaultSocketReadTimeoutMs();
        if (this$defaultSocketReadTimeoutMs == null ? other$defaultSocketReadTimeoutMs != null : !((Object)this$defaultSocketReadTimeoutMs).equals(other$defaultSocketReadTimeoutMs)) {
            return false;
        }
        Boolean this$statisticsDisabled = this.getStatisticsDisabled();
        Boolean other$statisticsDisabled = other.getStatisticsDisabled();
        if (this$statisticsDisabled == null ? other$statisticsDisabled != null : !((Object)this$statisticsDisabled).equals(other$statisticsDisabled)) {
            return false;
        }
        String this$masters = this.getMasters();
        String other$masters = other.getMasters();
        return !(this$masters == null ? other$masters != null : !this$masters.equals(other$masters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KuduDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $defaultAdminOperationTimeoutMs = this.getDefaultAdminOperationTimeoutMs();
        result = result * 59 + ($defaultAdminOperationTimeoutMs == null ? 43 : ((Object)$defaultAdminOperationTimeoutMs).hashCode());
        Integer $defaultOperationTimeoutMs = this.getDefaultOperationTimeoutMs();
        result = result * 59 + ($defaultOperationTimeoutMs == null ? 43 : ((Object)$defaultOperationTimeoutMs).hashCode());
        Integer $defaultSocketReadTimeoutMs = this.getDefaultSocketReadTimeoutMs();
        result = result * 59 + ($defaultSocketReadTimeoutMs == null ? 43 : ((Object)$defaultSocketReadTimeoutMs).hashCode());
        Boolean $statisticsDisabled = this.getStatisticsDisabled();
        result = result * 59 + ($statisticsDisabled == null ? 43 : ((Object)$statisticsDisabled).hashCode());
        String $masters = this.getMasters();
        result = result * 59 + ($masters == null ? 43 : $masters.hashCode());
        return result;
    }

    public String toString() {
        return "KuduDataNodeDTO(masters=" + this.getMasters() + ", defaultAdminOperationTimeoutMs=" + this.getDefaultAdminOperationTimeoutMs() + ", defaultOperationTimeoutMs=" + this.getDefaultOperationTimeoutMs() + ", defaultSocketReadTimeoutMs=" + this.getDefaultSocketReadTimeoutMs() + ", statisticsDisabled=" + this.getStatisticsDisabled() + ")";
    }

    public KuduDataNodeDTO() {
    }

    public KuduDataNodeDTO(String masters, Integer defaultAdminOperationTimeoutMs, Integer defaultOperationTimeoutMs, Integer defaultSocketReadTimeoutMs, Boolean statisticsDisabled) {
        this.masters = masters;
        this.defaultAdminOperationTimeoutMs = defaultAdminOperationTimeoutMs;
        this.defaultOperationTimeoutMs = defaultOperationTimeoutMs;
        this.defaultSocketReadTimeoutMs = defaultSocketReadTimeoutMs;
        this.statisticsDisabled = statisticsDisabled;
    }

    public static class KuduDataNodeDTOBuilder {
        private String masters;
        private Integer defaultAdminOperationTimeoutMs;
        private Integer defaultOperationTimeoutMs;
        private Integer defaultSocketReadTimeoutMs;
        private Boolean statisticsDisabled;

        KuduDataNodeDTOBuilder() {
        }

        public KuduDataNodeDTOBuilder masters(String masters) {
            this.masters = masters;
            return this;
        }

        public KuduDataNodeDTOBuilder defaultAdminOperationTimeoutMs(Integer defaultAdminOperationTimeoutMs) {
            this.defaultAdminOperationTimeoutMs = defaultAdminOperationTimeoutMs;
            return this;
        }

        public KuduDataNodeDTOBuilder defaultOperationTimeoutMs(Integer defaultOperationTimeoutMs) {
            this.defaultOperationTimeoutMs = defaultOperationTimeoutMs;
            return this;
        }

        public KuduDataNodeDTOBuilder defaultSocketReadTimeoutMs(Integer defaultSocketReadTimeoutMs) {
            this.defaultSocketReadTimeoutMs = defaultSocketReadTimeoutMs;
            return this;
        }

        public KuduDataNodeDTOBuilder statisticsDisabled(Boolean statisticsDisabled) {
            this.statisticsDisabled = statisticsDisabled;
            return this;
        }

        public KuduDataNodeDTO build() {
            return new KuduDataNodeDTO(this.masters, this.defaultAdminOperationTimeoutMs, this.defaultOperationTimeoutMs, this.defaultSocketReadTimeoutMs, this.statisticsDisabled);
        }

        public String toString() {
            return "KuduDataNodeDTO.KuduDataNodeDTOBuilder(masters=" + this.masters + ", defaultAdminOperationTimeoutMs=" + this.defaultAdminOperationTimeoutMs + ", defaultOperationTimeoutMs=" + this.defaultOperationTimeoutMs + ", defaultSocketReadTimeoutMs=" + this.defaultSocketReadTimeoutMs + ", statisticsDisabled=" + this.statisticsDisabled + ")";
        }
    }
}

