/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.cos;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.cos.COSSourceRequest;

@ApiModel(value="COS source info")
@JsonTypeDefine(value="COS")
public class COSSource
extends StreamSource {
    @ApiModelProperty(value="Path regex pattern for file, such as /a/b/*.txt", required=true)
    private String pattern;
    @ApiModelProperty(value="Cycle unit")
    private String cycleUnit;
    @ApiModelProperty(value="Whether retry")
    private Boolean retry;
    @ApiModelProperty(value="Data start time")
    private String dataTimeFrom;
    @ApiModelProperty(value="Data end time")
    private String dataTimeTo;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;
    @ApiModelProperty(value="Max file count")
    private String maxFileCount;
    @ApiModelProperty(value=" Type of data result for column separator         CSV format, set this parameter to a custom separator: , | :          Json format, set this parameter to json ")
    private String contentStyle;
    @ApiModelProperty(value="filterStreams")
    private List<String> filterStreams;

    public COSSource() {
        this.setSourceType("COS");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, COSSourceRequest::new);
    }

    protected COSSource(COSSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.pattern = ((COSSourceBuilder)b).pattern;
        this.cycleUnit = ((COSSourceBuilder)b).cycleUnit;
        this.retry = ((COSSourceBuilder)b).retry;
        this.dataTimeFrom = ((COSSourceBuilder)b).dataTimeFrom;
        this.dataTimeTo = ((COSSourceBuilder)b).dataTimeTo;
        this.timeOffset = ((COSSourceBuilder)b).timeOffset;
        this.maxFileCount = ((COSSourceBuilder)b).maxFileCount;
        this.contentStyle = ((COSSourceBuilder)b).contentStyle;
        this.filterStreams = ((COSSourceBuilder)b).filterStreams;
    }

    public static COSSourceBuilder<?, ?> builder() {
        return new COSSourceBuilderImpl();
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCycleUnit() {
        return this.cycleUnit;
    }

    public Boolean getRetry() {
        return this.retry;
    }

    public String getDataTimeFrom() {
        return this.dataTimeFrom;
    }

    public String getDataTimeTo() {
        return this.dataTimeTo;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public String getMaxFileCount() {
        return this.maxFileCount;
    }

    public String getContentStyle() {
        return this.contentStyle;
    }

    public List<String> getFilterStreams() {
        return this.filterStreams;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setCycleUnit(String cycleUnit) {
        this.cycleUnit = cycleUnit;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public void setDataTimeFrom(String dataTimeFrom) {
        this.dataTimeFrom = dataTimeFrom;
    }

    public void setDataTimeTo(String dataTimeTo) {
        this.dataTimeTo = dataTimeTo;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public void setMaxFileCount(String maxFileCount) {
        this.maxFileCount = maxFileCount;
    }

    public void setContentStyle(String contentStyle) {
        this.contentStyle = contentStyle;
    }

    public void setFilterStreams(List<String> filterStreams) {
        this.filterStreams = filterStreams;
    }

    public COSSource(String pattern, String cycleUnit, Boolean retry, String dataTimeFrom, String dataTimeTo, String timeOffset, String maxFileCount, String contentStyle, List<String> filterStreams) {
        this.pattern = pattern;
        this.cycleUnit = cycleUnit;
        this.retry = retry;
        this.dataTimeFrom = dataTimeFrom;
        this.dataTimeTo = dataTimeTo;
        this.timeOffset = timeOffset;
        this.maxFileCount = maxFileCount;
        this.contentStyle = contentStyle;
        this.filterStreams = filterStreams;
    }

    @Override
    public String toString() {
        return "COSSource(super=" + super.toString() + ", pattern=" + this.getPattern() + ", cycleUnit=" + this.getCycleUnit() + ", retry=" + this.getRetry() + ", dataTimeFrom=" + this.getDataTimeFrom() + ", dataTimeTo=" + this.getDataTimeTo() + ", timeOffset=" + this.getTimeOffset() + ", maxFileCount=" + this.getMaxFileCount() + ", contentStyle=" + this.getContentStyle() + ", filterStreams=" + this.getFilterStreams() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSSource)) {
            return false;
        }
        COSSource other = (COSSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$retry = this.getRetry();
        Boolean other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$cycleUnit = this.getCycleUnit();
        String other$cycleUnit = other.getCycleUnit();
        if (this$cycleUnit == null ? other$cycleUnit != null : !this$cycleUnit.equals(other$cycleUnit)) {
            return false;
        }
        String this$dataTimeFrom = this.getDataTimeFrom();
        String other$dataTimeFrom = other.getDataTimeFrom();
        if (this$dataTimeFrom == null ? other$dataTimeFrom != null : !this$dataTimeFrom.equals(other$dataTimeFrom)) {
            return false;
        }
        String this$dataTimeTo = this.getDataTimeTo();
        String other$dataTimeTo = other.getDataTimeTo();
        if (this$dataTimeTo == null ? other$dataTimeTo != null : !this$dataTimeTo.equals(other$dataTimeTo)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        if (this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset)) {
            return false;
        }
        String this$maxFileCount = this.getMaxFileCount();
        String other$maxFileCount = other.getMaxFileCount();
        if (this$maxFileCount == null ? other$maxFileCount != null : !this$maxFileCount.equals(other$maxFileCount)) {
            return false;
        }
        String this$contentStyle = this.getContentStyle();
        String other$contentStyle = other.getContentStyle();
        if (this$contentStyle == null ? other$contentStyle != null : !this$contentStyle.equals(other$contentStyle)) {
            return false;
        }
        List<String> this$filterStreams = this.getFilterStreams();
        List<String> other$filterStreams = other.getFilterStreams();
        return !(this$filterStreams == null ? other$filterStreams != null : !((Object)this$filterStreams).equals(other$filterStreams));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof COSSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $cycleUnit = this.getCycleUnit();
        result = result * 59 + ($cycleUnit == null ? 43 : $cycleUnit.hashCode());
        String $dataTimeFrom = this.getDataTimeFrom();
        result = result * 59 + ($dataTimeFrom == null ? 43 : $dataTimeFrom.hashCode());
        String $dataTimeTo = this.getDataTimeTo();
        result = result * 59 + ($dataTimeTo == null ? 43 : $dataTimeTo.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        String $maxFileCount = this.getMaxFileCount();
        result = result * 59 + ($maxFileCount == null ? 43 : $maxFileCount.hashCode());
        String $contentStyle = this.getContentStyle();
        result = result * 59 + ($contentStyle == null ? 43 : $contentStyle.hashCode());
        List<String> $filterStreams = this.getFilterStreams();
        result = result * 59 + ($filterStreams == null ? 43 : ((Object)$filterStreams).hashCode());
        return result;
    }

    private static final class COSSourceBuilderImpl
    extends COSSourceBuilder<COSSource, COSSourceBuilderImpl> {
        private COSSourceBuilderImpl() {
        }

        @Override
        protected COSSourceBuilderImpl self() {
            return this;
        }

        @Override
        public COSSource build() {
            return new COSSource(this);
        }
    }

    public static abstract class COSSourceBuilder<C extends COSSource, B extends COSSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String pattern;
        private String cycleUnit;
        private Boolean retry;
        private String dataTimeFrom;
        private String dataTimeTo;
        private String timeOffset;
        private String maxFileCount;
        private String contentStyle;
        private List<String> filterStreams;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B pattern(String pattern) {
            this.pattern = pattern;
            return (B)this.self();
        }

        public B cycleUnit(String cycleUnit) {
            this.cycleUnit = cycleUnit;
            return (B)this.self();
        }

        public B retry(Boolean retry) {
            this.retry = retry;
            return (B)this.self();
        }

        public B dataTimeFrom(String dataTimeFrom) {
            this.dataTimeFrom = dataTimeFrom;
            return (B)this.self();
        }

        public B dataTimeTo(String dataTimeTo) {
            this.dataTimeTo = dataTimeTo;
            return (B)this.self();
        }

        public B timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return (B)this.self();
        }

        public B maxFileCount(String maxFileCount) {
            this.maxFileCount = maxFileCount;
            return (B)this.self();
        }

        public B contentStyle(String contentStyle) {
            this.contentStyle = contentStyle;
            return (B)this.self();
        }

        public B filterStreams(List<String> filterStreams) {
            this.filterStreams = filterStreams;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "COSSource.COSSourceBuilder(super=" + super.toString() + ", pattern=" + this.pattern + ", cycleUnit=" + this.cycleUnit + ", retry=" + this.retry + ", dataTimeFrom=" + this.dataTimeFrom + ", dataTimeTo=" + this.dataTimeTo + ", timeOffset=" + this.timeOffset + ", maxFileCount=" + this.maxFileCount + ", contentStyle=" + this.contentStyle + ", filterStreams=" + this.filterStreams + ")";
        }
    }
}

