/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.mqtt;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.mqtt.MqttSourceRequest;

@ApiModel(value="Mqtt source info")
@JsonTypeDefine(value="MQTT")
public class MqttSource
extends StreamSource {
    @ApiModelProperty(value="ServerURI of the Mqtt server")
    private String serverURI;
    @ApiModelProperty(value="Username of the Mqtt server")
    private String username;
    @ApiModelProperty(value="Password of the Mqtt server")
    private String password;
    @ApiModelProperty(value="Topic of the Mqtt server")
    private String topic;
    @ApiModelProperty(value="Mqtt qos")
    private int qos = 1;
    @ApiModelProperty(value="Client Id")
    private String clientId;
    @ApiModelProperty(value="Mqtt version")
    private String mqttVersion;

    public MqttSource() {
        this.setSourceType("MQTT");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, MqttSourceRequest::new);
    }

    protected MqttSource(MqttSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.serverURI = ((MqttSourceBuilder)b).serverURI;
        this.username = ((MqttSourceBuilder)b).username;
        this.password = ((MqttSourceBuilder)b).password;
        this.topic = ((MqttSourceBuilder)b).topic;
        this.qos = ((MqttSourceBuilder)b).qos;
        this.clientId = ((MqttSourceBuilder)b).clientId;
        this.mqttVersion = ((MqttSourceBuilder)b).mqttVersion;
    }

    public static MqttSourceBuilder<?, ?> builder() {
        return new MqttSourceBuilderImpl();
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQos() {
        return this.qos;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getMqttVersion() {
        return this.mqttVersion;
    }

    public void setServerURI(String serverURI) {
        this.serverURI = serverURI;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setMqttVersion(String mqttVersion) {
        this.mqttVersion = mqttVersion;
    }

    public MqttSource(String serverURI, String username, String password, String topic, int qos, String clientId, String mqttVersion) {
        this.serverURI = serverURI;
        this.username = username;
        this.password = password;
        this.topic = topic;
        this.qos = qos;
        this.clientId = clientId;
        this.mqttVersion = mqttVersion;
    }

    @Override
    public String toString() {
        return "MqttSource(super=" + super.toString() + ", serverURI=" + this.getServerURI() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", topic=" + this.getTopic() + ", qos=" + this.getQos() + ", clientId=" + this.getClientId() + ", mqttVersion=" + this.getMqttVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttSource)) {
            return false;
        }
        MqttSource other = (MqttSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getQos() != other.getQos()) {
            return false;
        }
        String this$serverURI = this.getServerURI();
        String other$serverURI = other.getServerURI();
        if (this$serverURI == null ? other$serverURI != null : !this$serverURI.equals(other$serverURI)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$mqttVersion = this.getMqttVersion();
        String other$mqttVersion = other.getMqttVersion();
        return !(this$mqttVersion == null ? other$mqttVersion != null : !this$mqttVersion.equals(other$mqttVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MqttSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getQos();
        String $serverURI = this.getServerURI();
        result = result * 59 + ($serverURI == null ? 43 : $serverURI.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $mqttVersion = this.getMqttVersion();
        result = result * 59 + ($mqttVersion == null ? 43 : $mqttVersion.hashCode());
        return result;
    }

    private static final class MqttSourceBuilderImpl
    extends MqttSourceBuilder<MqttSource, MqttSourceBuilderImpl> {
        private MqttSourceBuilderImpl() {
        }

        @Override
        protected MqttSourceBuilderImpl self() {
            return this;
        }

        @Override
        public MqttSource build() {
            return new MqttSource(this);
        }
    }

    public static abstract class MqttSourceBuilder<C extends MqttSource, B extends MqttSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String serverURI;
        private String username;
        private String password;
        private String topic;
        private int qos;
        private String clientId;
        private String mqttVersion;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B serverURI(String serverURI) {
            this.serverURI = serverURI;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B topic(String topic) {
            this.topic = topic;
            return (B)this.self();
        }

        public B qos(int qos) {
            this.qos = qos;
            return (B)this.self();
        }

        public B clientId(String clientId) {
            this.clientId = clientId;
            return (B)this.self();
        }

        public B mqttVersion(String mqttVersion) {
            this.mqttVersion = mqttVersion;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MqttSource.MqttSourceBuilder(super=" + super.toString() + ", serverURI=" + this.serverURI + ", username=" + this.username + ", password=" + this.password + ", topic=" + this.topic + ", qos=" + this.qos + ", clientId=" + this.clientId + ", mqttVersion=" + this.mqttVersion + ")";
        }
    }
}

