/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network.tcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.dataproxy.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.ChannelOption;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.EventLoopGroup;
import org.apache.inlong.dataproxy.shaded.io.netty.util.HashedWheelTimer;
import org.apache.inlong.dataproxy.shaded.io.netty.util.Timeout;
import org.apache.inlong.dataproxy.shaded.io.netty.util.Timer;
import org.apache.inlong.dataproxy.shaded.io.netty.util.TimerTask;
import org.apache.inlong.dataproxy.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.network.ClientMgr;
import org.apache.inlong.sdk.dataproxy.network.SequentialID;
import org.apache.inlong.sdk.dataproxy.network.tcp.ClientPipelineFactory;
import org.apache.inlong.sdk.dataproxy.network.tcp.SendQos;
import org.apache.inlong.sdk.dataproxy.network.tcp.TcpCallFuture;
import org.apache.inlong.sdk.dataproxy.network.tcp.TcpNettyClient;
import org.apache.inlong.sdk.dataproxy.network.tcp.codec.DecodeObject;
import org.apache.inlong.sdk.dataproxy.network.tcp.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.sender.BaseSender;
import org.apache.inlong.sdk.dataproxy.sender.MsgSendCallback;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.utils.EventLoopUtil;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpClientMgr
implements ClientMgr {
    private static final Logger logger = LoggerFactory.getLogger(TcpClientMgr.class);
    private static final LogCounter sendExceptCnt = new LogCounter(10L, 100000L, 60000L);
    private static final LogCounter updConExptCnt = new LogCounter(10L, 100000L, 60000L);
    private static final LogCounter indexExptCnt = new LogCounter(10L, 100000L, 60000L);
    private static final LogCounter exptCounter = new LogCounter(10L, 100000L, 60000L);
    private static final LogCounter callbackExceptCnt = new LogCounter(10L, 100000L, 60000L);
    private static final AtomicLong timerRefCnt = new AtomicLong(0L);
    private static Timer timerObj;
    private final BaseSender baseSender;
    private final String senderId;
    private final TcpMsgSenderConfig tcpConfig;
    private final Bootstrap bootstrap;
    private final SequentialID messageIdGen = new SequentialID();
    private ConcurrentHashMap<String, TcpNettyClient> usingClientMaps = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TcpNettyClient> deletingClientMaps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, HostInfo> connFailNodeMap = new ConcurrentHashMap();
    private List<String> activeNodes = new ArrayList<String>();
    private volatile long lastUpdateTime = -1L;
    private final MaintThread maintThread;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicLong channelTermGen = new AtomicLong(0L);
    private final ConcurrentHashMap<Integer, TcpCallFuture> reqObjects = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Timeout> reqTimeouts = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, Boolean>> channelMsgIdMap = new ConcurrentHashMap();
    private final AtomicInteger reqSendIndex = new AtomicInteger(0);

    public TcpClientMgr(BaseSender baseSender, TcpMsgSenderConfig tcpConfig, ThreadFactory selfDefineFactory) {
        this.baseSender = baseSender;
        this.senderId = baseSender.getSenderId();
        this.tcpConfig = tcpConfig;
        this.bootstrap = this.buildBootstrap(selfDefineFactory);
        this.maintThread = new MaintThread();
    }

    @Override
    public boolean start(ProcessResult procResult) {
        if (!this.started.compareAndSet(false, true)) {
            return procResult.setSuccess();
        }
        if (timerRefCnt.incrementAndGet() == 1L) {
            timerObj = new HashedWheelTimer();
        }
        this.maintThread.start();
        logger.info("ClientMgr({}) started", (Object)this.senderId);
        return procResult.setSuccess();
    }

    @Override
    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        if (timerRefCnt.decrementAndGet() == 0L) {
            timerObj.stop();
        }
        this.bootstrap.config().group().shutdownGracefully();
        this.maintThread.shutDown();
        long startTime = System.currentTimeMillis();
        if (!this.reqTimeouts.isEmpty()) {
            this.notifyInflightMsgClosed();
        }
        this.activeNodes.clear();
        logger.info("ClientMgr({}) stopped, release cost {} ms!", (Object)this.senderId, (Object)(System.currentTimeMillis() - startTime));
    }

    @Override
    public int getInflightMsgCnt() {
        return this.reqTimeouts.size();
    }

    @Override
    public int getActiveNodeCnt() {
        return this.activeNodes.size();
    }

    @Override
    public void updateProxyInfoList(boolean nodeChanged, ConcurrentHashMap<String, HostInfo> hostInfoMap) {
        block14: {
            if (hostInfoMap.isEmpty() || !this.started.get()) {
                return;
            }
            long curTime = System.currentTimeMillis();
            try {
                ArrayList<HostInfo> candidateNodes = new ArrayList<HostInfo>(hostInfoMap.size());
                candidateNodes.addAll(hostInfoMap.values());
                Collections.sort(candidateNodes);
                Collections.shuffle(candidateNodes);
                int curTotalCnt = candidateNodes.size();
                int needActiveCnt = Math.min(this.tcpConfig.getAliveConnections(), curTotalCnt);
                int maxCycleCnt = 3;
                this.connFailNodeMap.clear();
                ArrayList<String> realHosts = new ArrayList<String>();
                ConcurrentHashMap<String, TcpNettyClient> tmpClientMaps = new ConcurrentHashMap<String, TcpNettyClient>();
                do {
                    int selectCnt = 0;
                    for (HostInfo hostInfo : candidateNodes) {
                        if (realHosts.contains(hostInfo.getReferenceName())) continue;
                        try {
                            TcpNettyClient client = new TcpNettyClient(this.senderId, this.bootstrap, hostInfo, this.tcpConfig);
                            if (!client.connect(false, this.channelTermGen.incrementAndGet())) {
                                this.connFailNodeMap.put(hostInfo.getReferenceName(), hostInfo);
                                client.close(false);
                                continue;
                            }
                            realHosts.add(hostInfo.getReferenceName());
                            tmpClientMaps.put(hostInfo.getReferenceName(), client);
                            if (++selectCnt < needActiveCnt) continue;
                            break;
                        }
                        catch (Throwable ex) {
                            if (!updConExptCnt.shouldPrint()) continue;
                            logger.warn("ClientMgr({}) build client {} exception", new Object[]{this.senderId, hostInfo.getReferenceName(), ex});
                        }
                    }
                    if (!realHosts.isEmpty()) break;
                    ProxyUtils.sleepSomeTime(1000L);
                } while (--maxCycleCnt > 0);
                if (realHosts.isEmpty()) {
                    if (nodeChanged) {
                        logger.error("ClientMgr({}) changed nodes, but all connect failure, nodes={}!", (Object)this.senderId, candidateNodes);
                    } else {
                        logger.error("ClientMgr({}) re-choose nodes, but all connect failure, nodes={}!", (Object)this.senderId, candidateNodes);
                    }
                } else {
                    this.lastUpdateTime = System.currentTimeMillis();
                    this.deletingClientMaps = this.usingClientMaps;
                    this.usingClientMaps = tmpClientMaps;
                    this.activeNodes = realHosts;
                    if (nodeChanged) {
                        logger.info("ClientMgr({}) changed nodes, wast {}ms, nodeCnt=(r:{}-a:{}), actives={}, fail={}", new Object[]{this.senderId, System.currentTimeMillis() - curTime, needActiveCnt, realHosts.size(), realHosts, this.connFailNodeMap.keySet()});
                    } else {
                        logger.info("ClientMgr({}) re-choose nodes, wast {}ms, nodeCnt=(r:{}-a:{}), actives={}, fail={}", new Object[]{this.senderId, System.currentTimeMillis() - curTime, needActiveCnt, realHosts.size(), realHosts, this.connFailNodeMap.keySet()});
                    }
                }
            }
            catch (Throwable ex) {
                if (!updConExptCnt.shouldPrint()) break block14;
                logger.warn("ClientMgr({}) update nodes throw exception", (Object)this.senderId, (Object)ex);
            }
        }
    }

    public boolean reportEvent(SendQos sendQos, TcpNettyClient client, EncodeObject encObject, MsgSendCallback callback, ProcessResult procResult) {
        if (!this.started.get()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        long clientTerm = client.getChanTermId();
        if (sendQos == SendQos.NO_ACK) {
            if (client.write(clientTerm, encObject, procResult)) {
                client.decInFlightMsgCnt(clientTerm);
            }
            return procResult.isSuccess();
        }
        TcpCallFuture newFuture = new TcpCallFuture(encObject, client.getClientAddr(), clientTerm, client.getChanStr(), callback);
        TcpCallFuture curFuture = this.reqObjects.putIfAbsent(encObject.getMessageId(), newFuture);
        if (curFuture != null) {
            if (sendExceptCnt.shouldPrint()) {
                logger.warn("ClientMgr({}) found message id {} has existed.", (Object)this.senderId, (Object)encObject.getMessageId());
            }
            return procResult.setFailResult(ErrorCode.DUPLICATED_MESSAGE_ID);
        }
        ConcurrentHashMap<Integer, Boolean> msgIdMap = this.channelMsgIdMap.get(client.getChanStr());
        if (msgIdMap == null) {
            ConcurrentHashMap tmpMsgIdMap = new ConcurrentHashMap();
            msgIdMap = this.channelMsgIdMap.putIfAbsent(client.getChanStr(), tmpMsgIdMap);
            if (msgIdMap == null) {
                msgIdMap = tmpMsgIdMap;
            }
        }
        msgIdMap.put(encObject.getMessageId(), newFuture.isAsyncCall());
        if (newFuture.isAsyncCall()) {
            this.reqTimeouts.put(encObject.getMessageId(), timerObj.newTimeout(new TimeoutTask(encObject.getMessageId()), this.tcpConfig.getRequestTimeoutMs(), TimeUnit.MILLISECONDS));
            if (!client.write(clientTerm, encObject, procResult)) {
                Timeout timeout = this.reqTimeouts.remove(newFuture.getMessageId());
                if (timeout != null) {
                    timeout.cancel();
                }
                this.rmvMsgStubInfo(newFuture.getMessageId());
            }
            return procResult.isSuccess();
        }
        if (!client.write(clientTerm, encObject, procResult)) {
            this.rmvMsgStubInfo(newFuture.getMessageId());
            return false;
        }
        boolean retValue = newFuture.get(procResult, this.tcpConfig.getRequestTimeoutMs(), TimeUnit.MILLISECONDS);
        if (this.rmvMsgStubInfo(newFuture.getMessageId())) {
            if (procResult.getErrCode() == ErrorCode.SEND_WAIT_TIMEOUT.getErrCode()) {
                client.setBusy(clientTerm);
            }
            client.decInFlightMsgCnt(clientTerm);
        }
        return retValue;
    }

    private boolean rmvMsgStubInfo(int messageId) {
        TcpCallFuture curFuture = this.reqObjects.remove(messageId);
        if (curFuture == null) {
            return false;
        }
        ConcurrentHashMap<Integer, Boolean> msgIdMap = this.channelMsgIdMap.get(curFuture.getChanStr());
        if (msgIdMap != null) {
            msgIdMap.remove(curFuture.getMessageId());
        }
        return true;
    }

    public boolean getClientByRoundRobin(ProcessResult procResult) {
        if (!this.started.get()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        List<String> curNodes = this.activeNodes;
        int curNodeSize = curNodes.size();
        if (curNodeSize == 0) {
            return procResult.setFailResult(ErrorCode.EMPTY_ACTIVE_NODE_SET);
        }
        TcpNettyClient back1thClient = null;
        int nullClientCnt = 0;
        int unWritableCnt = 0;
        int startPos = this.reqSendIndex.getAndIncrement();
        for (int step = 0; step < curNodeSize; ++step) {
            int indexPos = (startPos = Math.abs(startPos + 1)) % curNodeSize;
            if (indexPos >= curNodes.size()) {
                if (!indexExptCnt.shouldPrint()) continue;
                logger.warn("IndexOutOfBounds, startPos={}, curNodeSize={}, indexPos={}\uff0c realSize={}", new Object[]{startPos, curNodeSize, indexPos, curNodes.size()});
                continue;
            }
            String curNode = curNodes.get(indexPos);
            TcpNettyClient client = this.usingClientMaps.get(curNode);
            if (client == null) {
                ++nullClientCnt;
                continue;
            }
            if (!client.isActive()) continue;
            if (client.getChannel().isWritable()) {
                if (this.tcpConfig.getMaxMsgInFlightPerConn() > 0 && client.getMsgInflightCnt() > this.tcpConfig.getMaxMsgInFlightPerConn()) {
                    back1thClient = client;
                    continue;
                }
                client.incClientUsingCnt();
                return procResult.setSuccess(client);
            }
            ++unWritableCnt;
        }
        if (nullClientCnt == curNodeSize) {
            return procResult.setFailResult(ErrorCode.EMPTY_ACTIVE_NODE_SET);
        }
        if (unWritableCnt + nullClientCnt == curNodeSize) {
            return procResult.setFailResult(ErrorCode.EMPTY_WRITABLE_NODE_SET);
        }
        if (back1thClient != null) {
            back1thClient.incClientUsingCnt();
            return procResult.setSuccess(back1thClient);
        }
        return procResult.setFailResult(ErrorCode.NO_VALID_REMOTE_NODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedbackMsgResponse(String channelStr, DecodeObject decObject) {
        TcpCallFuture callFuture;
        Timeout timeoutTask = this.reqTimeouts.remove(decObject.getMessageId());
        if (timeoutTask != null) {
            timeoutTask.cancel();
        }
        if ((callFuture = this.reqObjects.remove(decObject.getMessageId())) == null) {
            return;
        }
        long curTime = System.currentTimeMillis();
        ConcurrentHashMap<Integer, Boolean> inflightMsgIds = this.channelMsgIdMap.get(channelStr);
        if (inflightMsgIds != null) {
            inflightMsgIds.remove(decObject.getMessageId());
        }
        try {
            callFuture.onMessageAck(decObject.getSendResult());
        }
        catch (Throwable ex) {
            if (callbackExceptCnt.shouldPrint()) {
                logger.info("ClientMgr({}) response come, callback exception!", (Object)this.senderId, (Object)ex);
            }
        }
        finally {
            this.descInflightMsgCnt(callFuture);
            this.releaseAsyncCachedPermits(callFuture);
            if (decObject.getSendResult().isSuccess()) {
                this.baseSender.getMetricHolder().addCallbackSucMetric(callFuture.getGroupId(), callFuture.getStreamId(), callFuture.getMsgCnt(), curTime - callFuture.getRtTime(), System.currentTimeMillis() - curTime);
            } else {
                this.baseSender.getMetricHolder().addCallbackFailMetric(decObject.getSendResult().getErrCode(), callFuture.getGroupId(), callFuture.getStreamId(), callFuture.getMsgCnt(), System.currentTimeMillis() - curTime);
            }
        }
    }

    public void setChannelFrozen(String channelStr) {
        Map inflightMsgIds = this.channelMsgIdMap.get(channelStr);
        if (inflightMsgIds == null) {
            return;
        }
        for (Integer messageId : inflightMsgIds.keySet()) {
            TcpCallFuture callFuture;
            if (messageId == null || (callFuture = this.reqObjects.get(messageId)) == null) continue;
            TcpNettyClient nettyTcpClient = this.usingClientMaps.get(callFuture.getClientAddr());
            if (nettyTcpClient != null && nettyTcpClient.getChanTermId() == callFuture.getChanTerm()) {
                nettyTcpClient.setFrozen(callFuture.getChanTerm());
                return;
            }
            nettyTcpClient = this.deletingClientMaps.get(callFuture.getClientAddr());
            if (nettyTcpClient == null || nettyTcpClient.getChanTermId() != callFuture.getChanTerm()) break;
            nettyTcpClient.setFrozen(callFuture.getChanTerm());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChannelDisconnected(String channelStr) {
        Map inflightMsgIds = this.channelMsgIdMap.remove(channelStr);
        if (inflightMsgIds == null || inflightMsgIds.isEmpty()) {
            return;
        }
        for (Integer messageId : inflightMsgIds.keySet()) {
            TcpCallFuture callFuture;
            if (messageId == null) continue;
            Timeout timeoutTask = this.reqTimeouts.remove(messageId);
            if (timeoutTask != null) {
                timeoutTask.cancel();
            }
            if ((callFuture = this.reqObjects.remove(messageId)) == null) continue;
            long curTime = System.currentTimeMillis();
            TcpNettyClient nettyTcpClient = this.usingClientMaps.get(callFuture.getClientAddr());
            if (nettyTcpClient != null && nettyTcpClient.getChanTermId() == callFuture.getChanTerm()) {
                try {
                    nettyTcpClient.getChannel().eventLoop().execute(() -> callFuture.onMessageAck(new ProcessResult(ErrorCode.CONNECTION_BREAK)));
                }
                catch (Throwable ex) {
                    if (callbackExceptCnt.shouldPrint()) {
                        logger.info("ClientMgr({}) disconnected, callback exception!", (Object)this.senderId, (Object)ex);
                    }
                }
                finally {
                    nettyTcpClient.decInFlightMsgCnt(callFuture.getChanTerm());
                    this.releaseAsyncCachedPermits(callFuture);
                    this.baseSender.getMetricHolder().addCallbackFailMetric(ErrorCode.CONNECTION_BREAK.getErrCode(), callFuture.getGroupId(), callFuture.getStreamId(), callFuture.getMsgCnt(), System.currentTimeMillis() - curTime);
                }
                return;
            }
            nettyTcpClient = this.deletingClientMaps.get(callFuture.getClientAddr());
            if (nettyTcpClient == null || nettyTcpClient.getChanTermId() != callFuture.getChanTerm()) continue;
            try {
                nettyTcpClient.getChannel().eventLoop().execute(() -> callFuture.onMessageAck(new ProcessResult(ErrorCode.CONNECTION_BREAK)));
            }
            catch (Throwable ex) {
                if (!callbackExceptCnt.shouldPrint()) continue;
                logger.info("ClientMgr({}) disconnected, callback2 exception!", (Object)this.senderId, (Object)ex);
            }
            finally {
                nettyTcpClient.decInFlightMsgCnt(callFuture.getChanTerm());
                this.releaseAsyncCachedPermits(callFuture);
                this.baseSender.getMetricHolder().addCallbackFailMetric(ErrorCode.CONNECTION_BREAK.getErrCode(), callFuture.getGroupId(), callFuture.getStreamId(), callFuture.getMsgCnt(), System.currentTimeMillis() - curTime);
            }
        }
    }

    public String getSenderId() {
        return this.senderId;
    }

    public int getNextMsgId() {
        return this.messageIdGen.getNextInt();
    }

    private void descInflightMsgCnt(TcpCallFuture callFuture) {
        TcpNettyClient nettyTcpClient = this.usingClientMaps.get(callFuture.getClientAddr());
        if (nettyTcpClient != null && nettyTcpClient.getChanTermId() == callFuture.getChanTerm()) {
            nettyTcpClient.decInFlightMsgCnt(callFuture.getChanTerm());
            return;
        }
        nettyTcpClient = this.deletingClientMaps.get(callFuture.getClientAddr());
        if (nettyTcpClient != null && nettyTcpClient.getChanTermId() == callFuture.getChanTerm()) {
            nettyTcpClient.decInFlightMsgCnt(callFuture.getChanTerm());
        }
    }

    private Bootstrap buildBootstrap(ThreadFactory selfFactory) {
        if (selfFactory == null) {
            selfFactory = new DefaultThreadFactory("sdk-netty-workers", Thread.currentThread().isDaemon());
        }
        EventLoopGroup eventLoopGroup = EventLoopUtil.newEventLoopGroup(this.tcpConfig.getNettyWorkerThreadNum(), this.tcpConfig.isEnableEpollBusyWait(), selfFactory);
        Bootstrap tmpBootstrap = new Bootstrap();
        tmpBootstrap.group(eventLoopGroup);
        tmpBootstrap.option(ChannelOption.TCP_NODELAY, true);
        tmpBootstrap.option(ChannelOption.SO_REUSEADDR, true);
        tmpBootstrap.channel(EventLoopUtil.getClientSocketChannelClass(eventLoopGroup));
        if (this.tcpConfig.getRcvBufferSize() > 0) {
            tmpBootstrap.option(ChannelOption.SO_RCVBUF, this.tcpConfig.getRcvBufferSize());
        }
        if (this.tcpConfig.getSendBufferSize() > 0) {
            tmpBootstrap.option(ChannelOption.SO_SNDBUF, this.tcpConfig.getSendBufferSize());
        }
        tmpBootstrap.handler(new ClientPipelineFactory(this));
        return tmpBootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInflightMsgClosed() {
        for (Integer messageId : this.reqTimeouts.keySet()) {
            TcpCallFuture callFuture;
            if (messageId == null) continue;
            Timeout timeoutTask = this.reqTimeouts.remove(messageId);
            if (timeoutTask != null) {
                timeoutTask.cancel();
            }
            if ((callFuture = this.reqObjects.remove(messageId)) == null) continue;
            long curTime = System.currentTimeMillis();
            TcpNettyClient nettyTcpClient = this.usingClientMaps.get(callFuture.getClientAddr());
            if (nettyTcpClient != null && nettyTcpClient.getChanTermId() == callFuture.getChanTerm()) {
                try {
                    nettyTcpClient.getChannel().eventLoop().execute(() -> callFuture.onMessageAck(new ProcessResult(ErrorCode.SDK_CLOSED)));
                }
                catch (Throwable ex) {
                    if (callbackExceptCnt.shouldPrint()) {
                        logger.info("ClientMgr({}) closed, callback exception!", (Object)this.senderId, (Object)ex);
                    }
                }
                finally {
                    nettyTcpClient.decInFlightMsgCnt(callFuture.getChanTerm());
                    this.releaseAsyncCachedPermits(callFuture);
                    this.baseSender.getMetricHolder().addCallbackFailMetric(ErrorCode.SDK_CLOSED.getErrCode(), callFuture.getGroupId(), callFuture.getStreamId(), callFuture.getMsgCnt(), System.currentTimeMillis() - curTime);
                }
                return;
            }
            nettyTcpClient = this.deletingClientMaps.get(callFuture.getClientAddr());
            if (nettyTcpClient == null || nettyTcpClient.getChanTermId() != callFuture.getChanTerm()) continue;
            try {
                nettyTcpClient.getChannel().eventLoop().execute(() -> callFuture.onMessageAck(new ProcessResult(ErrorCode.SDK_CLOSED)));
            }
            catch (Throwable ex) {
                if (!callbackExceptCnt.shouldPrint()) continue;
                logger.info("ClientMgr({}) closed, callback2 exception!", (Object)this.senderId, (Object)ex);
            }
            finally {
                nettyTcpClient.decInFlightMsgCnt(callFuture.getChanTerm());
                this.releaseAsyncCachedPermits(callFuture);
                this.baseSender.getMetricHolder().addCallbackFailMetric(ErrorCode.SDK_CLOSED.getErrCode(), callFuture.getGroupId(), callFuture.getStreamId(), callFuture.getMsgCnt(), System.currentTimeMillis() - curTime);
            }
        }
    }

    private void releaseAsyncCachedPermits(TcpCallFuture callFuture) {
        if (callFuture.isAsyncCall()) {
            this.baseSender.releaseCachePermits(callFuture.getEventSize());
        }
    }

    public class TimeoutTask
    implements TimerTask {
        private final int messageId;

        public TimeoutTask(int messageId) {
            this.messageId = messageId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Timeout timeout) throws Exception {
            TcpCallFuture future;
            Timeout timeoutMsg = (Timeout)TcpClientMgr.this.reqTimeouts.remove(this.messageId);
            if (timeoutMsg != null) {
                timeoutMsg.cancel();
            }
            if ((future = (TcpCallFuture)TcpClientMgr.this.reqObjects.remove(this.messageId)) == null) {
                return;
            }
            long curTime = System.currentTimeMillis();
            TcpNettyClient nettyTcpClient = (TcpNettyClient)TcpClientMgr.this.usingClientMaps.get(future.getClientAddr());
            if (nettyTcpClient != null && nettyTcpClient.getChanTermId() == future.getChanTerm()) {
                ConcurrentHashMap messageIdMap = (ConcurrentHashMap)TcpClientMgr.this.channelMsgIdMap.get(future.getChanStr());
                if (messageIdMap != null) {
                    messageIdMap.remove(this.messageId);
                }
                try {
                    nettyTcpClient.getChannel().eventLoop().execute(() -> future.onMessageAck(new ProcessResult(ErrorCode.SEND_WAIT_TIMEOUT)));
                }
                catch (Throwable ex) {
                    if (callbackExceptCnt.shouldPrint()) {
                        logger.info("ClientMgr({}) msg timeout, callback exception!", (Object)TcpClientMgr.this.senderId, (Object)ex);
                    }
                }
                finally {
                    nettyTcpClient.decInFlightMsgCnt(future.getChanTerm());
                    TcpClientMgr.this.releaseAsyncCachedPermits(future);
                    TcpClientMgr.this.baseSender.getMetricHolder().addCallbackFailMetric(ErrorCode.SEND_WAIT_TIMEOUT.getErrCode(), future.getGroupId(), future.getStreamId(), future.getMsgCnt(), System.currentTimeMillis() - curTime);
                }
                return;
            }
            nettyTcpClient = (TcpNettyClient)TcpClientMgr.this.deletingClientMaps.get(future.getClientAddr());
            if (nettyTcpClient != null && nettyTcpClient.getChanTermId() == future.getChanTerm()) {
                ConcurrentHashMap messageIdMap = (ConcurrentHashMap)TcpClientMgr.this.channelMsgIdMap.get(future.getChanStr());
                if (messageIdMap != null) {
                    messageIdMap.remove(this.messageId);
                }
                try {
                    nettyTcpClient.getChannel().eventLoop().execute(() -> future.onMessageAck(new ProcessResult(ErrorCode.SEND_WAIT_TIMEOUT)));
                }
                catch (Throwable ex) {
                    if (callbackExceptCnt.shouldPrint()) {
                        logger.info("ClientMgr({}) msg timeout, callback2 exception!", (Object)TcpClientMgr.this.senderId, (Object)ex);
                    }
                }
                finally {
                    nettyTcpClient.decInFlightMsgCnt(future.getChanTerm());
                    TcpClientMgr.this.releaseAsyncCachedPermits(future);
                    TcpClientMgr.this.baseSender.getMetricHolder().addCallbackFailMetric(ErrorCode.SEND_WAIT_TIMEOUT.getErrCode(), future.getGroupId(), future.getStreamId(), future.getMsgCnt(), System.currentTimeMillis() - curTime);
                }
            }
        }
    }

    private class MaintThread
    extends Thread {
        private volatile boolean bShutDown = false;

        public MaintThread() {
            this.setName("ClientMgrMaint-" + TcpClientMgr.this.senderId);
        }

        public void shutDown() {
            logger.info("ClientMgr({}) shutdown MaintThread!", (Object)TcpClientMgr.this.senderId);
            this.bShutDown = true;
            this.interrupt();
        }

        @Override
        public void run() {
            logger.info("ClientMgr({}) start MaintThread!", (Object)TcpClientMgr.this.senderId);
            long checkRound = 0L;
            ProcessResult procResult = new ProcessResult();
            HashSet<String> failNodes = new HashSet<String>();
            while (!this.bShutDown) {
                boolean printFailNodes;
                block11: {
                    printFailNodes = Math.abs(checkRound++) % 90L == 0L;
                    try {
                        long curTime = System.currentTimeMillis();
                        if (TcpClientMgr.this.deletingClientMaps != null && !TcpClientMgr.this.deletingClientMaps.isEmpty() && TcpClientMgr.this.lastUpdateTime > 0L && curTime - TcpClientMgr.this.lastUpdateTime > TcpClientMgr.this.tcpConfig.getConCloseWaitPeriodMs()) {
                            for (TcpNettyClient client : TcpClientMgr.this.deletingClientMaps.values()) {
                                if (client == null) continue;
                                client.close(false);
                            }
                            TcpClientMgr.this.deletingClientMaps.clear();
                        }
                        for (TcpNettyClient nettyTcpClient : TcpClientMgr.this.usingClientMaps.values()) {
                            if (nettyTcpClient == null) continue;
                            if (nettyTcpClient.isActive()) {
                                if (nettyTcpClient.isIdleClient(curTime)) {
                                    nettyTcpClient.sendHeartBeatMsg(procResult);
                                }
                            } else if (nettyTcpClient.getClientUsingCnt() <= 0 && nettyTcpClient.getMsgInflightCnt() <= 0 || curTime - nettyTcpClient.getChanInvalidTime() > TcpClientMgr.this.tcpConfig.getConCloseWaitPeriodMs()) {
                                nettyTcpClient.reconnect(false, TcpClientMgr.this.channelTermGen.incrementAndGet());
                            }
                            if (!printFailNodes || !nettyTcpClient.isConFailNodes()) continue;
                            failNodes.add(nettyTcpClient.getClientAddr());
                        }
                    }
                    catch (Throwable ex) {
                        if (!exptCounter.shouldPrint()) break block11;
                        logger.warn("ClientMgr({}) MaintThread throw exception", (Object)TcpClientMgr.this.senderId, (Object)ex);
                    }
                }
                if (printFailNodes && !failNodes.isEmpty()) {
                    logger.warn("ClientMgr({}) found continue connect fail nodes: {}", (Object)TcpClientMgr.this.senderId, failNodes);
                    failNodes.clear();
                }
                if (this.bShutDown) break;
                ProxyUtils.sleepSomeTime(2000L);
            }
            logger.info("ClientMgr({}) exit MaintThread!", (Object)TcpClientMgr.this.senderId);
        }
    }
}

