/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.dolphinscheduler;

import java.util.Map;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.schedule.dolphinscheduler.DolphinScheduleUtils;
import org.apache.inlong.manager.schedule.exception.DolphinScheduleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DolphinScheduleOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DolphinScheduleOperator.class);

    public long checkAndGetUniqueId(String url, String token, String searchVal) {
        try {
            return DolphinScheduleUtils.checkAndGetUniqueId(url, token, searchVal);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected wrong in check id uniqueness: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected wrong in check id uniqueness: %s", e.getMessage()));
        }
    }

    public long creatProject(String url, String token, String projectName, String description) {
        try {
            return DolphinScheduleUtils.creatProject(url, token, projectName, description);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while creating new project: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected error while creating new project: %s", e.getMessage()));
        }
    }

    public Map<Long, String> queryAllProcessDef(String url, String token) {
        try {
            return DolphinScheduleUtils.queryAllProcessDef(url, token);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while querying process definition: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected error while querying process definition: %s", e.getMessage()));
        }
    }

    public long genTaskCode(String url, String token) {
        try {
            return DolphinScheduleUtils.genTaskCode(url, token);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected wrong in generating task code: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected wrong in generating task code: %s", e.getMessage()));
        }
    }

    public long createProcessDef(String url, String token, String name, String desc, long taskCode, String inlongManagerUrl, String username, String password, long offset, String groupId) {
        try {
            return DolphinScheduleUtils.createProcessDef(url, token, name, desc, taskCode, inlongManagerUrl, username, password, offset, groupId);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected wrong in creating process definition: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected wrong in creating process definition: %s", e.getMessage()));
        }
    }

    public boolean releaseProcessDef(String processDefUrl, long processDefCode, String token, String status) {
        try {
            return DolphinScheduleUtils.releaseProcessDef(processDefUrl, processDefCode, token, status);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected wrong in release process definition: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected wrong in release process definition: %s", e.getMessage()));
        }
    }

    public int createScheduleForProcessDef(String url, long processDefCode, String token, ScheduleInfo scheduleInfo) {
        try {
            return DolphinScheduleUtils.createScheduleForProcessDef(url, processDefCode, token, scheduleInfo);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected wrong in creating schedule for process definition: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected wrong in creating schedule for process definition: %s", e.getMessage()));
        }
    }

    public boolean onlineScheduleForProcessDef(String scheduleUrl, int scheduleId, String token) {
        try {
            return DolphinScheduleUtils.onlineScheduleForProcessDef(scheduleUrl, scheduleId, token);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected wrong in online process definition: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected wrong in online process definition: %s", e.getMessage()));
        }
    }

    public void deleteProcessDef(String processDefUrl, String token, long processDefCode) {
        try {
            DolphinScheduleUtils.delete(processDefUrl, token, processDefCode);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected wrong in deleting process definition: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected wrong in deleting process definition: %s", e.getMessage()));
        }
    }

    public void deleteProject(String projectBaseUrl, String token, long projectCode) {
        try {
            DolphinScheduleUtils.delete(projectBaseUrl, token, projectCode);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected wrong in deleting project definition: ", (Throwable)e);
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected wrong in deleting project definition: %s", e.getMessage()));
        }
    }
}

