/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="redisLoad")
public class RedisLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -1L;
    public static final String ENABLE_CODE = "true";
    private static final String EXTEND_ATTR_KEY_NAME = "keyName";
    private static final String EXTEND_ATTR_VALUE_NAME = "keyValue";
    public static final String DATA_TYPE = "data-type";
    public static final String REDIS_MODE = "redis-mode";
    public static final String SCHEMA_MAPPING_MODE = "schema-mapping-mode";
    public static final String CLUSTER_MODE_STANDALONE = "standalone";
    public static final String VALUE_HOST = "host";
    public static final String VALUE_PORT = "port";
    public static final String PASSWORD = "password";
    public static final String CLUSTER_MODE_CLUSTER = "cluster";
    public static final String CLUSTER_NODES = "cluster-nodes";
    public static final String CLUSTER_PASSWORD = "cluster.password";
    public static final String MASTER_NAME = "master.name";
    public static final String SENTINELS_INFO = "sentinels.info";
    public static final String SENTINELS_PASSWORD = "sentinels.password";
    public static final String DATABASE = "database";
    public static final String MAX_IDLE = "maxIdle";
    public static final String SINK_MAX_RETRIES = "sink.max-retries";
    public static final String MAX_TOTAL = "maxTotal";
    public static final String MIN_IDLE = "minIdle";
    public static final String SO_TIMEOUT = "soTimeout";
    public static final String TIMEOUT = "timeout";
    public static final String EXPIRE_TIME = "expire-time";
    public static final String CONNECTOR_KEY = "connector";
    public static final String CONNECTOR_REDIS_INLONG = "redis-inlong";
    private Format format;
    private String clusterMode;
    private String dataType;
    private String schemaMapMode;
    private String host;
    private Integer port;
    private String clusterNodes;
    private String masterName;
    private String sentinelsInfo;
    private Integer database;
    private String password;
    private Integer ttl;
    private Integer timeout;
    private Integer soTimeout;
    private Integer maxTotal;
    private Integer maxIdle;
    private Integer minIdle;
    private Integer maxRetries;
    public static final String DDL_ATTR_PREFIX = "ddl.";

    @JsonCreator
    public RedisLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="clusterMode") String clusterMode, @JsonProperty(value="dataType") String dataType, @JsonProperty(value="schemaMapMode") String schemaMapMode, @Nullable @JsonProperty(value="host") String host, @Nullable @JsonProperty(value="port") Integer port, @Nullable @JsonProperty(value="clusterNodes") String clusterNodes, @Nullable @JsonProperty(value="masterName") String masterName, @Nullable @JsonProperty(value="sentinelsInfo") String sentinelsInfo, @Nullable @JsonProperty(value="database") Integer database, @Nullable @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="ttl") Integer ttl, @Nonnull @JsonProperty(value="format") Format format, @Nullable @JsonProperty(value="timeout") Integer timeout, @Nullable @JsonProperty(value="soTimeout") Integer soTimeout, @Nullable @JsonProperty(value="maxTotal") Integer maxTotal, @Nullable @JsonProperty(value="maxIdle") Integer maxIdle, @Nullable @JsonProperty(value="minIdle") Integer minIdle, @Nullable @JsonProperty(value="maxRetries") Integer maxRetries) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.clusterMode = clusterMode;
        this.dataType = dataType;
        this.schemaMapMode = schemaMapMode;
        this.host = host;
        this.port = port;
        this.clusterNodes = clusterNodes;
        this.masterName = masterName;
        this.sentinelsInfo = sentinelsInfo;
        this.database = database;
        this.password = password;
        this.ttl = ttl;
        this.format = (Format)Preconditions.checkNotNull((Object)format, (Object)"format is null");
        this.timeout = timeout;
        this.soTimeout = soTimeout;
        this.maxTotal = maxTotal;
        this.maxIdle = maxIdle;
        this.minIdle = minIdle;
        this.maxRetries = maxRetries;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put(DATA_TYPE, this.dataType);
        options.put(REDIS_MODE, this.clusterMode);
        options.put(SCHEMA_MAPPING_MODE, this.schemaMapMode);
        if (CLUSTER_MODE_STANDALONE.equals(this.clusterMode)) {
            options.put(VALUE_HOST, this.host);
            options.put(VALUE_PORT, String.valueOf(this.port));
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                options.put(PASSWORD, this.password);
            }
        } else if (CLUSTER_MODE_CLUSTER.equals(this.clusterMode)) {
            options.put(CLUSTER_NODES, this.clusterNodes);
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                options.put(CLUSTER_PASSWORD, this.password);
            }
        } else {
            options.put(MASTER_NAME, this.masterName);
            options.put(SENTINELS_INFO, this.sentinelsInfo);
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                options.put(SENTINELS_PASSWORD, this.password);
            }
        }
        if (this.database != null) {
            options.put(DATABASE, String.valueOf(this.database));
        }
        if (this.maxIdle != null) {
            options.put(MAX_IDLE, String.valueOf(this.maxIdle));
        }
        if (this.maxRetries != null) {
            options.put(SINK_MAX_RETRIES, String.valueOf(this.maxRetries));
        }
        if (this.maxTotal != null) {
            options.put(MAX_TOTAL, String.valueOf(this.maxTotal));
        }
        if (this.minIdle != null) {
            options.put(MIN_IDLE, String.valueOf(this.minIdle));
        }
        if (this.soTimeout != null) {
            options.put(SO_TIMEOUT, String.valueOf(this.soTimeout));
        }
        if (this.timeout != null) {
            options.put(TIMEOUT, String.valueOf(this.timeout));
        }
        if (this.ttl != null) {
            options.put(EXPIRE_TIME, this.ttl + "s");
        }
        options.putAll(this.format.generateOptions(false));
        Map<String, String> properties = this.getProperties();
        if (properties != null) {
            properties.forEach((keyName, ddlValue) -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{keyName}) && keyName.startsWith(DDL_ATTR_PREFIX)) {
                    String ddlKeyName = keyName.substring(DDL_ATTR_PREFIX.length());
                    options.put(ddlKeyName, (String)ddlValue);
                }
            });
        }
        options.put(CONNECTOR_KEY, CONNECTOR_REDIS_INLONG);
        return options;
    }

    @Override
    public String genTableName() {
        return this.getName();
    }

    @Override
    public String getPrimaryKey() {
        return null;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    public Format getFormat() {
        return this.format;
    }

    public String getClusterMode() {
        return this.clusterMode;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getSchemaMapMode() {
        return this.schemaMapMode;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getClusterNodes() {
        return this.clusterNodes;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getSentinelsInfo() {
        return this.sentinelsInfo;
    }

    public Integer getDatabase() {
        return this.database;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public Integer getMaxTotal() {
        return this.maxTotal;
    }

    public Integer getMaxIdle() {
        return this.maxIdle;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setClusterMode(String clusterMode) {
        this.clusterMode = clusterMode;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setSchemaMapMode(String schemaMapMode) {
        this.schemaMapMode = schemaMapMode;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setSentinelsInfo(String sentinelsInfo) {
        this.sentinelsInfo = sentinelsInfo;
    }

    public void setDatabase(Integer database) {
        this.database = database;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public String toString() {
        return "RedisLoadNode(format=" + this.getFormat() + ", clusterMode=" + this.getClusterMode() + ", dataType=" + this.getDataType() + ", schemaMapMode=" + this.getSchemaMapMode() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", clusterNodes=" + this.getClusterNodes() + ", masterName=" + this.getMasterName() + ", sentinelsInfo=" + this.getSentinelsInfo() + ", database=" + this.getDatabase() + ", password=" + this.getPassword() + ", ttl=" + this.getTtl() + ", timeout=" + this.getTimeout() + ", soTimeout=" + this.getSoTimeout() + ", maxTotal=" + this.getMaxTotal() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", maxRetries=" + this.getMaxRetries() + ")";
    }

    public RedisLoadNode() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisLoadNode)) {
            return false;
        }
        RedisLoadNode other = (RedisLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$database = this.getDatabase();
        Integer other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Integer this$soTimeout = this.getSoTimeout();
        Integer other$soTimeout = other.getSoTimeout();
        if (this$soTimeout == null ? other$soTimeout != null : !((Object)this$soTimeout).equals(other$soTimeout)) {
            return false;
        }
        Integer this$maxTotal = this.getMaxTotal();
        Integer other$maxTotal = other.getMaxTotal();
        if (this$maxTotal == null ? other$maxTotal != null : !((Object)this$maxTotal).equals(other$maxTotal)) {
            return false;
        }
        Integer this$maxIdle = this.getMaxIdle();
        Integer other$maxIdle = other.getMaxIdle();
        if (this$maxIdle == null ? other$maxIdle != null : !((Object)this$maxIdle).equals(other$maxIdle)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        Integer this$maxRetries = this.getMaxRetries();
        Integer other$maxRetries = other.getMaxRetries();
        if (this$maxRetries == null ? other$maxRetries != null : !((Object)this$maxRetries).equals(other$maxRetries)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$clusterMode = this.getClusterMode();
        String other$clusterMode = other.getClusterMode();
        if (this$clusterMode == null ? other$clusterMode != null : !this$clusterMode.equals(other$clusterMode)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$schemaMapMode = this.getSchemaMapMode();
        String other$schemaMapMode = other.getSchemaMapMode();
        if (this$schemaMapMode == null ? other$schemaMapMode != null : !this$schemaMapMode.equals(other$schemaMapMode)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$clusterNodes = this.getClusterNodes();
        String other$clusterNodes = other.getClusterNodes();
        if (this$clusterNodes == null ? other$clusterNodes != null : !this$clusterNodes.equals(other$clusterNodes)) {
            return false;
        }
        String this$masterName = this.getMasterName();
        String other$masterName = other.getMasterName();
        if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
            return false;
        }
        String this$sentinelsInfo = this.getSentinelsInfo();
        String other$sentinelsInfo = other.getSentinelsInfo();
        if (this$sentinelsInfo == null ? other$sentinelsInfo != null : !this$sentinelsInfo.equals(other$sentinelsInfo)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RedisLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Integer $soTimeout = this.getSoTimeout();
        result = result * 59 + ($soTimeout == null ? 43 : ((Object)$soTimeout).hashCode());
        Integer $maxTotal = this.getMaxTotal();
        result = result * 59 + ($maxTotal == null ? 43 : ((Object)$maxTotal).hashCode());
        Integer $maxIdle = this.getMaxIdle();
        result = result * 59 + ($maxIdle == null ? 43 : ((Object)$maxIdle).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        Integer $maxRetries = this.getMaxRetries();
        result = result * 59 + ($maxRetries == null ? 43 : ((Object)$maxRetries).hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $clusterMode = this.getClusterMode();
        result = result * 59 + ($clusterMode == null ? 43 : $clusterMode.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $schemaMapMode = this.getSchemaMapMode();
        result = result * 59 + ($schemaMapMode == null ? 43 : $schemaMapMode.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $clusterNodes = this.getClusterNodes();
        result = result * 59 + ($clusterNodes == null ? 43 : $clusterNodes.hashCode());
        String $masterName = this.getMasterName();
        result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
        String $sentinelsInfo = this.getSentinelsInfo();
        result = result * 59 + ($sentinelsInfo == null ? 43 : $sentinelsInfo.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }
}

