/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.LogicOperator;
import org.apache.inlong.sort.protocol.transformation.SingleValueCompareOperator;

@JsonTypeName(value="singleValueFilter")
public class SingleValueFilterFunction
extends FilterFunction
implements Serializable {
    private static final long serialVersionUID = 8953419088907830331L;
    @JsonProperty(value="source")
    private FunctionParam source;
    @JsonProperty(value="target")
    private FunctionParam target;
    @JsonProperty(value="compareOperator")
    private SingleValueCompareOperator compareOperator;

    @JsonCreator
    public SingleValueFilterFunction(@JsonProperty(value="logicOperator") LogicOperator logicOperator, @JsonProperty(value="source") FunctionParam source, @JsonProperty(value="compareOperator") SingleValueCompareOperator compareOperator, @JsonProperty(value="target") FunctionParam target) {
        this.source = (FunctionParam)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.target = (FunctionParam)Preconditions.checkNotNull((Object)target, (Object)"target is null");
        this.compareOperator = (SingleValueCompareOperator)Preconditions.checkNotNull((Object)compareOperator, (Object)"compareOperator is null");
        this.logicOperator = (LogicOperator)Preconditions.checkNotNull((Object)logicOperator, (Object)"logicOperator is null");
    }

    @Override
    public String getName() {
        return "singleValueFilter";
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.logicOperator, this.source, this.compareOperator, this.target);
    }

    @Override
    public String format() {
        return String.format("%s %s %s %s", this.logicOperator.format(), this.source.format(), this.compareOperator.format(), this.target.format());
    }

    public FunctionParam getSource() {
        return this.source;
    }

    public FunctionParam getTarget() {
        return this.target;
    }

    public SingleValueCompareOperator getCompareOperator() {
        return this.compareOperator;
    }

    public void setSource(FunctionParam source) {
        this.source = source;
    }

    public void setTarget(FunctionParam target) {
        this.target = target;
    }

    public void setCompareOperator(SingleValueCompareOperator compareOperator) {
        this.compareOperator = compareOperator;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleValueFilterFunction)) {
            return false;
        }
        SingleValueFilterFunction other = (SingleValueFilterFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionParam this$source = this.getSource();
        FunctionParam other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        FunctionParam this$target = this.getTarget();
        FunctionParam other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        SingleValueCompareOperator this$compareOperator = this.getCompareOperator();
        SingleValueCompareOperator other$compareOperator = other.getCompareOperator();
        return !(this$compareOperator == null ? other$compareOperator != null : !this$compareOperator.equals(other$compareOperator));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SingleValueFilterFunction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionParam $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        FunctionParam $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        SingleValueCompareOperator $compareOperator = this.getCompareOperator();
        result = result * 59 + ($compareOperator == null ? 43 : $compareOperator.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SingleValueFilterFunction(source=" + this.getSource() + ", target=" + this.getTarget() + ", compareOperator=" + this.getCompareOperator() + ")";
    }

    public SingleValueFilterFunction() {
    }
}

