/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd;

import com.moilioncircle.redis.replicator.util.ByteBuilder;

public class RedisCodec {
    private static final byte[] NUMERALS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public byte[] encode(byte[] bytes) {
        ByteBuilder s = ByteBuilder.allocate(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            if (b == 10) {
                s.put((byte)92);
                s.put((byte)110);
                continue;
            }
            if (b == 13) {
                s.put((byte)92);
                s.put((byte)114);
                continue;
            }
            if (b == 9) {
                s.put((byte)92);
                s.put((byte)116);
                continue;
            }
            if (b == 8) {
                s.put((byte)92);
                s.put((byte)98);
                continue;
            }
            if (b == 7) {
                s.put((byte)92);
                s.put((byte)97);
                continue;
            }
            if (b == 92) {
                s.put((byte)92);
                s.put((byte)92);
                continue;
            }
            if (b == 34) {
                s.put((byte)92);
                s.put((byte)34);
                continue;
            }
            if (b > 32 && b < 127) {
                s.put((byte)b);
                continue;
            }
            s.put((byte)92);
            s.put((byte)120);
            int ma = b >>> 4;
            int mi = b & 0xF;
            s.put(NUMERALS[ma]);
            s.put(NUMERALS[mi]);
        }
        return s.array();
    }

    public byte[] decode(byte[] bytes) {
        ByteBuilder s = ByteBuilder.allocate(bytes.length);
        block13: for (int i = 0; i < bytes.length; ++i) {
            switch (bytes[i]) {
                case 92: {
                    if (++i >= bytes.length) continue block13;
                    switch (bytes[i]) {
                        case 110: {
                            s.put((byte)10);
                            continue block13;
                        }
                        case 114: {
                            s.put((byte)13);
                            continue block13;
                        }
                        case 116: {
                            s.put((byte)9);
                            continue block13;
                        }
                        case 98: {
                            s.put((byte)8);
                            continue block13;
                        }
                        case 97: {
                            s.put((byte)7);
                            continue block13;
                        }
                        case 120: {
                            if (i + 2 >= bytes.length) {
                                s.put((byte)92);
                                s.put((byte)120);
                                continue block13;
                            }
                            char hig = (char)bytes[++i];
                            char low = (char)bytes[++i];
                            try {
                                s.put((byte)Integer.parseInt(new String(new char[]{hig, low}), 16));
                            }
                            catch (Exception e) {
                                s.put((byte)92);
                                s.put((byte)120);
                                s.put((byte)hig);
                                s.put((byte)low);
                            }
                            continue block13;
                        }
                    }
                    s.put(bytes[i]);
                    continue block13;
                }
                default: {
                    s.put(bytes[i]);
                }
            }
        }
        return s.array();
    }
}

