/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.inlong.audit.entity.AuditRoute;

public class RouteUtils {
    public static boolean isValidRegex(String regex) {
        if (regex == null || regex.isEmpty()) {
            return false;
        }
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public static boolean matchesAuditRoute(String auditId, String inlongGroupId, List<AuditRoute> auditRouteList) {
        if (auditRouteList == null || auditRouteList.isEmpty()) {
            return true;
        }
        try {
            for (AuditRoute route : auditRouteList) {
                boolean excludeGroupId;
                boolean auditIdMatch = Pattern.matches(route.getAuditId(), auditId);
                boolean inlongGroupIdIsEmpty = inlongGroupId == null || inlongGroupId.trim().isEmpty();
                boolean includeGroupId = inlongGroupIdIsEmpty || Pattern.matches(route.getInlongGroupIdsInclude(), inlongGroupId);
                boolean bl = excludeGroupId = !inlongGroupIdIsEmpty && route.getInlongGroupIdsExclude() != null && !route.getInlongGroupIdsExclude().trim().isEmpty() && Pattern.matches(route.getInlongGroupIdsExclude(), inlongGroupId);
                if (!auditIdMatch || !includeGroupId || excludeGroupId) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static String extractAddress(String jdbcUrl) {
        if (jdbcUrl == null || jdbcUrl.trim().isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile("^jdbc:\\w+://([\\d\\.]+):(\\d+)");
        Matcher matcher = pattern.matcher(jdbcUrl);
        if (matcher.find()) {
            return matcher.group(1) + ":" + matcher.group(2);
        }
        return null;
    }
}

