/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.dao.mapper;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.inlong.manager.common.tenant.MultiTenantQuery;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.pojo.group.InlongGroupBriefInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicRequest;
import org.apache.inlong.manager.pojo.sort.standalone.SortSourceGroupInfo;
import org.springframework.stereotype.Repository;

@MultiTenantQuery
@Repository
public interface InlongGroupEntityMapper {
    public int insert(InlongGroupEntity var1);

    public InlongGroupEntity selectByPrimaryKey(Integer var1);

    public List<Map<String, Object>> countGroupByUser(@Param(value="username") String var1, @Param(value="inlongGroupMode") Integer var2, @Param(value="mqType") String var3);

    public InlongGroupEntity selectByGroupId(String var1);

    @MultiTenantQuery(with=false)
    public InlongGroupEntity selectByGroupIdWithoutTenant(String var1);

    public InlongGroupEntity selectByGroupIdForUpdate(String var1);

    public List<InlongGroupEntity> selectByCondition(InlongGroupPageRequest var1);

    public List<InlongGroupBriefInfo> selectBriefList(InlongGroupPageRequest var1);

    public List<InlongGroupEntity> selectByClusterTag(@Param(value="inlongClusterTag") String var1);

    @MultiTenantQuery(with=false)
    public List<InlongGroupEntity> selectByClusterTagWithoutTenant(@Param(value="inlongClusterTag") String var1);

    public List<InlongGroupEntity> selectByTopicRequest(InlongGroupTopicRequest var1);

    public List<InlongGroupEntity> selectByInlongGroupIds(@Param(value="groupIdList") List<String> var1);

    @MultiTenantQuery(with=false)
    @Options(resultSetType=ResultSetType.FORWARD_ONLY, fetchSize=-2147483648)
    public Cursor<SortSourceGroupInfo> selectAllGroups();

    @MultiTenantQuery(with=false)
    public List<String> selectDeletedGroupIdsWithTimeBefore(@Param(value="timeBefore") Date var1, @Param(value="limit") Integer var2);

    @MultiTenantQuery(with=false)
    public List<String> selectDeletedGroupIdsWithTimeAfter(@Param(value="timeAfter") Date var1, @Param(value="limit") Integer var2);

    public int updateByPrimaryKey(InlongGroupEntity var1);

    public int updateByIdentifierSelective(InlongGroupEntity var1);

    public int updateStatus(@Param(value="groupId") String var1, @Param(value="status") Integer var2, @Param(value="modifier") String var3);

    public int deleteByPrimaryKey(Integer var1);

    public int deleteByInlongGroupIds(@Param(value="groupIdList") List<String> var1);

    @MultiTenantQuery(with=false)
    public List<InlongGroupEntity> selectAllGroupsByTenant(@Param(value="tenant") String var1);

    @MultiTenantQuery(with=false)
    public int migrate(@Param(value="groupId") String var1, @Param(value="sourceTenant") String var2, @Param(value="targetTenant") String var3);
}

