/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="arithmetic", names={"gcd"}, parameter="(Numeric numeric1,Numeric numeric2)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return 0 if both inputs are zero;", "- Return greatest common divisor (the largest positive number that divides both inputs with no remainder)."}, examples={"gcd(3.141,3.846) = 0.003"})
public class GcdFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(GcdFunction.class);
    private final ValueParser firstNumParser;
    private final ValueParser secondNumTypeParser;

    public GcdFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.firstNumParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.secondNumTypeParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object firstNumObj = this.firstNumParser.parse(sourceData, rowIndex, context);
        Object secondNumObj = this.secondNumTypeParser.parse(sourceData, rowIndex, context);
        if (firstNumObj == null || secondNumObj == null) {
            return null;
        }
        try {
            BigDecimal firstNum = OperatorTools.parseBigDecimal(firstNumObj);
            BigDecimal secondNum = OperatorTools.parseBigDecimal(secondNumObj);
            return GcdFunction.gcdForBigDecimals(firstNum, secondNum);
        }
        catch (Exception e) {
            log.error("Parse error", (Throwable)e);
            return null;
        }
    }

    public static BigDecimal gcd(BigDecimal a, BigDecimal b) {
        if (b.compareTo(BigDecimal.ZERO) == 0) {
            return a;
        }
        BigDecimal remainder = a.remainder(b);
        return GcdFunction.gcd(b, remainder);
    }

    public static BigDecimal gcdForBigDecimals(BigDecimal a, BigDecimal b) {
        int scaleA = a.scale();
        int scaleB = b.scale();
        BigDecimal scaledA = a.movePointRight(Math.max(scaleA, scaleB));
        BigDecimal scaledB = b.movePointRight(Math.max(scaleA, scaleB));
        BigDecimal gcdValue = GcdFunction.gcd(scaledA, scaledB);
        return gcdValue.movePointLeft(Math.max(scaleA, scaleB));
    }
}

