/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"ascii"}, parameter="(String str)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return the numeric value of the first character of 'str'."}, examples={"ascii('abc') = 97", "ascii('A') = 65", "ascii(null) = \"\""})
public class AsciiFunction
implements ValueParser {
    private final ValueParser stringParser;

    public AsciiFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObj == null) {
            return null;
        }
        String str = OperatorTools.parseString(stringObj);
        if (str == null || str.isEmpty()) {
            return null;
        }
        return (int)str.charAt(0);
    }
}

