/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.LocalDate;
import java.time.ZoneId;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="temporal", names={"localdate", "currentdate", "current_date", "curdate"}, parameter="([String timeZoneStr])", descriptions={"- Return the current date in the specified 'timeZoneStr'."}, examples={"localDate(\"UTC\") = currentDate", "localDate() = currentDate"})
public class LocalDateFunction
implements ValueParser {
    private ValueParser stringParser;

    public LocalDateFunction(Function expr) {
        if (expr.getParameters() != null) {
            this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.stringParser != null) {
            String zoneString = OperatorTools.parseString(this.stringParser.parse(sourceData, rowIndex, context));
            return LocalDate.now(ZoneId.of(zoneString));
        }
        return LocalDate.now(ZoneId.systemDefault());
    }
}

