/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.operator;

import net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.ExpressionOperator;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.operator.TransformOperator;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformOperator(values={IsBooleanExpression.class})
public class IsBooleanOperator
implements ExpressionOperator {
    private static final Logger log = LoggerFactory.getLogger(IsBooleanOperator.class);
    private ValueParser leftParser;
    private ExpressionOperator operator;
    private final boolean isNot;
    private final Boolean isTure;

    public IsBooleanOperator(IsBooleanExpression expr) {
        try {
            this.leftParser = OperatorTools.buildParser(expr.getLeftExpression());
        }
        catch (Exception e) {
            this.operator = OperatorTools.buildOperator(expr.getLeftExpression());
        }
        this.isNot = expr.isNot();
        this.isTure = expr.isTrue();
    }

    @Override
    public boolean check(SourceData sourceData, int rowIndex, Context context) {
        Object leftObj = null;
        leftObj = this.leftParser != null ? this.leftParser.parse(sourceData, rowIndex, context) : Boolean.valueOf(this.operator.check(sourceData, rowIndex, context));
        Boolean ret = null;
        try {
            ret = Double.parseDouble(leftObj.toString()) != 0.0;
        }
        catch (Exception e) {
            ret = this.isTure.equals(leftObj);
        }
        if (this.isNot) {
            return ret == false;
        }
        return ret;
    }
}

