/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformParser(values={Modulo.class})
public class ModuloParser
implements ValueParser {
    private ValueParser left;
    private ValueParser right;

    public ModuloParser(Modulo expr) {
        this.left = OperatorTools.buildParser(expr.getLeftExpression());
        this.right = OperatorTools.buildParser(expr.getRightExpression());
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftObj = this.left.parse(sourceData, rowIndex, context);
        Object rightObj = this.right.parse(sourceData, rowIndex, context);
        BigDecimal leftValue = OperatorTools.parseBigDecimal(leftObj);
        BigDecimal rightValue = OperatorTools.parseBigDecimal(rightObj);
        return leftValue.remainder(rightValue);
    }
}

