/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgcsv;

import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.apache.inlong.sort.formats.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InLongMsgCsvUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InLongMsgCsvUtils.class);
    public static final String FORMAT_DELETE_HEAD_DELIMITER = "format.delete-head-delimiter";
    public static final boolean DEFAULT_DELETE_HEAD_DELIMITER = true;

    public static InLongMsgHead parseHead(String attr) {
        Timestamp time;
        String streamId;
        Map<String, String> attributes = InLongMsgUtils.parseAttr(attr);
        if (attributes.containsKey("streamId")) {
            streamId = attributes.get("streamId");
        } else if (attributes.containsKey("tid")) {
            streamId = attributes.get("tid");
        } else if (attributes.containsKey("iname")) {
            streamId = attributes.get("iname");
        } else {
            throw new IllegalArgumentException("Could not find streamId or tid or iname in attributes!");
        }
        if (attributes.containsKey("t")) {
            String date = attributes.get("t").trim();
            time = InLongMsgUtils.parseDateTime(date);
        } else if (attributes.containsKey("dt")) {
            String epoch = attributes.get("dt").trim();
            time = InLongMsgUtils.parseEpochTime(epoch);
        } else {
            throw new IllegalArgumentException("Could not find t or dt in attributes!");
        }
        List<String> predefinedFields = InLongMsgUtils.getPredefinedFields(attributes);
        return new InLongMsgHead(attributes, streamId, time, predefinedFields);
    }

    public static List<InLongMsgBody> parseBodyList(byte[] bytes, String charset, char delimiter, Character lineDelimiter, Character escapeChar, Character quoteChar, boolean deleteHeadDelimiter) {
        String bodyStr = new String(bytes, Charset.forName(charset));
        String[][] split = StringUtils.splitCsv(bodyStr, Character.valueOf(delimiter), escapeChar, quoteChar, lineDelimiter, deleteHeadDelimiter, true);
        return Arrays.stream(split).map(line -> new InLongMsgBody(null, null, Arrays.asList(line), Collections.emptyMap())).collect(Collectors.toList());
    }

    public static Row deserializeRow(RowFormatInfo rowFormatInfo, String nullLiteral, List<String> predefinedFields, List<String> fields) throws Exception {
        Object field;
        String fieldText;
        FormatInfo fieldFormatInfo;
        String fieldName;
        int i;
        String[] fieldNames = rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = rowFormatInfo.getFieldFormatInfos();
        int actualNumFields = predefinedFields.size() + fields.size();
        if (actualNumFields != fieldNames.length) {
            LOG.warn("The number of fields mismatches: expected={}, actual={}. PredefinedFields=[{}], Fields=[{}]", fieldNames.length, actualNumFields, predefinedFields, fields);
        }
        Row row = new Row(fieldNames.length);
        for (i = 0; i < predefinedFields.size() && i < fieldNames.length; ++i) {
            fieldName = fieldNames[i];
            fieldFormatInfo = fieldFormatInfos[i];
            fieldText = predefinedFields.get(i);
            field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, nullLiteral, null);
            row.setField(i, field);
        }
        for (i = 0; i < fields.size() && i + predefinedFields.size() < fieldNames.length; ++i) {
            fieldName = fieldNames[i + predefinedFields.size()];
            fieldFormatInfo = fieldFormatInfos[i + predefinedFields.size()];
            fieldText = fields.get(i);
            field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, nullLiteral, null);
            row.setField(i + predefinedFields.size(), field);
        }
        for (i = predefinedFields.size() + fields.size(); i < fieldNames.length; ++i) {
            row.setField(i, null);
        }
        return row;
    }
}

