/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.kv;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.inlong.sort.formats.base.TextFormatOptions;

public class KvCommons {
    static void validateFormatOptions(ReadableConfig tableOptions) {
        KvCommons.validateCharacterVal(tableOptions, TextFormatOptions.FIELD_DELIMITER, true);
        KvCommons.validateCharacterVal(tableOptions, TextFormatOptions.KV_DELIMITER, true);
        KvCommons.validateCharacterVal(tableOptions, TextFormatOptions.KV_ENTRY_DELIMITER, true);
        KvCommons.validateCharacterVal(tableOptions, TextFormatOptions.QUOTE_CHARACTER);
        KvCommons.validateCharacterVal(tableOptions, TextFormatOptions.ESCAPE_CHARACTER);
    }

    private static void validateCharacterVal(ReadableConfig tableOptions, ConfigOption<String> option) {
        KvCommons.validateCharacterVal(tableOptions, option, false);
    }

    private static void validateCharacterVal(ReadableConfig tableOptions, ConfigOption<String> option, boolean unescape) {
        String value;
        if (!tableOptions.getOptional(option).isPresent()) {
            return;
        }
        String string = value = unescape ? StringEscapeUtils.unescapeJava((String)tableOptions.get(option)) : (String)tableOptions.get(option);
        if (value.length() != 1) {
            throw new ValidationException(String.format("Option '%s.%s' must be a String with single character, but was: %s", "inlong-kv", option.key(), tableOptions.get(option)));
        }
    }
}

