/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.kv;

import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.DefaultSerializationSchema;
import org.apache.inlong.sort.formats.base.RowDataToFieldConverters;
import org.apache.inlong.sort.formats.base.TableFormatConstants;
import org.apache.inlong.sort.formats.base.TableFormatForRowDataUtils;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.kv.KvFormatBuilder;
import org.apache.inlong.sort.formats.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvRowDataSerializationSchema
extends DefaultSerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(KvRowDataSerializationSchema.class);
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character entryDelimiter;
    @Nonnull
    private final Character kvDelimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;
    private final RowDataToFieldConverters.RowFieldConverter[] rowFieldConverters;

    public KvRowDataSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo) {
        this(rowFormatInfo, "UTF-8", Character.valueOf('&'), Character.valueOf('='), TableFormatConstants.DEFAULT_ESCAPE_CHARACTER, TableFormatConstants.DEFAULT_QUOTE_CHARACTER, TableFormatConstants.DEFAULT_NULL_LITERAL);
    }

    public KvRowDataSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral) {
        this(rowFormatInfo, charset, entryDelimiter, kvDelimiter, escapeChar, quoteChar, nullLiteral, false);
    }

    public KvRowDataSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, @Nullable boolean ignoreErrors) {
        super(ignoreErrors);
        this.rowFormatInfo = rowFormatInfo;
        FormatInfo[] fieldFormatInfos = rowFormatInfo.getFieldFormatInfos();
        this.rowFieldConverters = new RowDataToFieldConverters.RowFieldConverter[fieldFormatInfos.length];
        for (int i = 0; i < this.rowFieldConverters.length; ++i) {
            this.rowFieldConverters[i] = RowDataToFieldConverters.createNullableRowFieldConverter(TableFormatForRowDataUtils.deriveLogicalType(fieldFormatInfos[i]));
        }
        this.charset = charset;
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
    }

    @Override
    public byte[] serializeInternal(RowData rowData) {
        if (rowData == null) {
            return null;
        }
        try {
            String[] fieldNames = this.rowFormatInfo.getFieldNames();
            FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
            if (rowData.getArity() != fieldFormatInfos.length) {
                LOG.warn("The number of fields mismatches: expected=[{}], actual=[{}]. Row=[{}].", fieldNames.length, rowData.getArity(), rowData);
            }
            String[] fieldTexts = new String[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldText;
                if (i >= rowData.getArity()) {
                    fieldTexts[i] = this.nullLiteral == null ? "" : this.nullLiteral;
                    continue;
                }
                Object field = this.rowFieldConverters[i].convert(rowData, i);
                fieldTexts[i] = fieldText = TableFormatUtils.serializeBasicField(fieldNames[i], fieldFormatInfos[i], field, this.nullLiteral);
            }
            String text = StringUtils.concatKv(fieldNames, fieldTexts, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar);
            return text.getBytes(Charset.forName(this.charset));
        }
        catch (Throwable t2) {
            throw new RuntimeException(String.format("Could not properly serialize kv. Row=[%s]. FormatInfo=[%s].", rowData, this.rowFormatInfo), t2);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KvRowDataSerializationSchema that = (KvRowDataSerializationSchema)o;
        return Objects.equals(this.rowFormatInfo, that.rowFormatInfo) && Objects.equals(this.charset, that.charset) && Objects.equals(this.entryDelimiter, that.entryDelimiter) && Objects.equals(this.kvDelimiter, that.kvDelimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rowFormatInfo, this.charset, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar, this.nullLiteral);
    }

    public static class Builder
    extends KvFormatBuilder<Builder> {
        public Builder(RowFormatInfo rowFormatInfo) {
            super(rowFormatInfo);
        }

        public KvRowDataSerializationSchema build() {
            return new KvRowDataSerializationSchema(this.rowFormatInfo, this.charset, Character.valueOf(this.entryDelimiter), Character.valueOf(this.kvDelimiter), this.escapeChar, this.quoteChar, this.nullLiteral, this.ignoreErrors);
        }
    }
}

