/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.store.service.consume;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.store.config.MessageQueueConfig;
import org.apache.inlong.audit.store.config.StoreConfig;
import org.apache.inlong.audit.store.service.InsertData;
import org.apache.inlong.audit.store.service.consume.BaseConsume;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarConsume
extends BaseConsume {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarConsume.class);
    private final ConcurrentHashMap<String, List<Consumer<byte[]>>> topicConsumerMap = new ConcurrentHashMap();

    public PulsarConsume(List<InsertData> insertServiceList, StoreConfig storeConfig, MessageQueueConfig mqConfig) {
        super(insertServiceList, storeConfig, mqConfig);
    }

    public void start() {
        String pulsarUrl = this.mqConfig.getPulsarServerUrl();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pulsarUrl), (Object)"no pulsar server url specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.mqConfig.getPulsarTopic()), (Object)"no pulsar topic specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.mqConfig.getPulsarConsumerSubName()), (Object)"no pulsar consumeSubName specified");
        PulsarClient pulsarClient = this.getOrCreatePulsarClient(pulsarUrl);
        this.updateConcurrentConsumer(pulsarClient);
    }

    private PulsarClient getOrCreatePulsarClient(String pulsarServerUrl) {
        LOG.info("start consumer pulsarServerUrl = {}", (Object)pulsarServerUrl);
        PulsarClient pulsarClient = null;
        ClientBuilder builder = PulsarClient.builder();
        try {
            if (this.mqConfig.isPulsarEnableAuth() && StringUtils.isNotEmpty((CharSequence)this.mqConfig.getPulsarToken())) {
                builder.authentication(AuthenticationFactory.token((String)this.mqConfig.getPulsarToken()));
            }
            pulsarClient = builder.serviceUrl(pulsarServerUrl).connectionTimeout(this.mqConfig.getClientOperationTimeoutSecond(), TimeUnit.SECONDS).build();
        }
        catch (PulsarClientException e) {
            LOG.error("getOrCreatePulsarClient has pulsar {} err {}", (Object)pulsarServerUrl, (Object)e);
        }
        return pulsarClient;
    }

    protected void updateConcurrentConsumer(PulsarClient pulsarClient) {
        block3: {
            int createNum;
            int currentConsumerNum;
            List list;
            block2: {
                list = this.topicConsumerMap.computeIfAbsent(this.mqConfig.getPulsarTopic(), key -> new ArrayList());
                currentConsumerNum = list.size();
                createNum = this.mqConfig.getConcurrentConsumerNum() - currentConsumerNum;
                if (createNum <= 0) break block2;
                for (int i = 0; i < this.mqConfig.getConcurrentConsumerNum(); ++i) {
                    Consumer consumer = this.createConsumer(pulsarClient, this.mqConfig.getPulsarTopic());
                    if (consumer == null) continue;
                    list.add(consumer);
                }
                break block3;
            }
            if (createNum >= 0) break block3;
            int removeIndex = currentConsumerNum - 1;
            for (int i = createNum; i < 0; ++i) {
                Consumer consumer = (Consumer)list.remove(removeIndex);
                consumer.closeAsync();
                --removeIndex;
            }
        }
    }

    protected Consumer<byte[]> createConsumer(PulsarClient pulsarClient, String topic) {
        Consumer consumer = null;
        if (pulsarClient != null && StringUtils.isNotEmpty((CharSequence)topic)) {
            LOG.info("createConsumer has topic {}, subName {}", (Object)topic, (Object)this.mqConfig.getPulsarConsumerSubName());
            try {
                consumer = pulsarClient.newConsumer().subscriptionName(this.mqConfig.getPulsarConsumerSubName()).subscriptionType(SubscriptionType.Shared).topic(new String[]{topic}).receiverQueueSize(this.mqConfig.getConsumerReceiveQueueSize()).enableRetry(this.mqConfig.isPulsarConsumerEnableRetry()).messageListener((MessageListener)new /* Unavailable Anonymous Inner Class!! */).subscribe();
            }
            catch (PulsarClientException e) {
                LOG.error("createConsumer has topic {}, subName {}, err {}", new Object[]{topic, this.mqConfig.getPulsarConsumerSubName(), e});
            }
        }
        return consumer;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

