/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.InlongConsume;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.InlongConsumeClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.consume.InlongConsumeBriefInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumeCountInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumeInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumePageRequest;
import org.apache.inlong.manager.pojo.consume.InlongConsumeRequest;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;

public class InlongConsumeImpl
implements InlongConsume {
    private final InlongConsumeClient consumeClient;

    public InlongConsumeImpl(ClientConfiguration configuration) {
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.consumeClient = clientFactory.getConsumeClient();
    }

    @Override
    public Integer save(InlongConsumeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong consume request cannot be null");
        Preconditions.expectNotBlank((String)request.getTopic(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong consume topic cannot be null");
        Preconditions.expectNotBlank((String)request.getConsumerGroup(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong consume topic cannot be null");
        return this.consumeClient.save(request);
    }

    @Override
    public InlongConsumeInfo get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"inlong consume id cannot be null");
        return this.consumeClient.get(id);
    }

    @Override
    public InlongConsumeCountInfo countStatusByUser() {
        return this.consumeClient.countStatusByUser();
    }

    @Override
    public PageResult<InlongConsumeBriefInfo> list(InlongConsumePageRequest request) {
        return this.consumeClient.list(request);
    }

    @Override
    public Integer update(InlongConsumeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong consume request cannot be null");
        return this.consumeClient.update(request);
    }

    @Override
    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"inlong consume id cannot be null");
        return this.consumeClient.delete(id);
    }

    @Override
    public WorkflowResult startProcess(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"inlong consume id cannot be null");
        return this.consumeClient.startProcess(id);
    }
}

