/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.service;

import java.util.List;
import org.apache.inlong.manager.pojo.common.BatchResult;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.group.InlongGroupBriefInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupResetRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicRequest;
import org.apache.inlong.manager.pojo.schedule.OfflineJobRequest;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface InlongGroupApi {
    @GET(value="group/exist/{id}")
    public Call<Response<Boolean>> isGroupExists(@Path(value="id") String var1);

    @GET(value="group/get/{id}")
    public Call<Response<Object>> getGroupInfo(@Path(value="id") String var1);

    @POST(value="group/list")
    public Call<Response<PageResult<InlongGroupBriefInfo>>> listGroups(@Body InlongGroupPageRequest var1);

    @POST(value="group/save")
    public Call<Response<String>> createGroup(@Body InlongGroupRequest var1);

    @POST(value="group/batchSave")
    public Call<Response<List<BatchResult>>> batchCreateGroup(@Body List<InlongGroupRequest> var1);

    @POST(value="group/update")
    public Call<Response<String>> updateGroup(@Body InlongGroupRequest var1);

    @POST(value="group/startProcess/{id}")
    public Call<Response<WorkflowResult>> startProcess(@Path(value="id") String var1);

    @POST(value="group/batchStartProcess/{id}")
    public Call<Response<WorkflowResult>> batchStartProcess(@Body List<String> var1);

    @POST(value="group/suspendProcessAsync/{id}")
    public Call<Response<String>> suspendProcessAsync(@Path(value="id") String var1);

    @POST(value="group/suspendProcess/{id}")
    public Call<Response<WorkflowResult>> suspendProcess(@Path(value="id") String var1);

    @POST(value="group/restartProcessAsync/{id}")
    public Call<Response<String>> restartProcessAsync(@Path(value="id") String var1);

    @POST(value="group/restartProcess/{id}")
    public Call<Response<WorkflowResult>> restartProcess(@Path(value="id") String var1);

    @DELETE(value="group/deleteAsync/{id}")
    public Call<Response<String>> deleteGroupAsync(@Path(value="id") String var1);

    @DELETE(value="group/delete/{id}")
    public Call<Response<Boolean>> deleteGroup(@Path(value="id") String var1);

    @POST(value="group/reset")
    public Call<Response<Boolean>> resetGroup(@Body InlongGroupResetRequest var1);

    @GET(value="group/countByStatus")
    public Call<Response<Object>> countGroupByUser();

    @GET(value="group/getTenant/{groupId}")
    public Call<Response<String>> getTenant(@Path(value="groupId") String var1);

    @GET(value="group/getTopic/{id}")
    public Call<Response<Object>> getTopic(@Path(value="id") String var1);

    @GET(value="group/listTopics")
    public Call<Response<List<InlongGroupTopicInfo>>> listTopics(@Body InlongGroupTopicRequest var1);

    @GET(value="group/switch/start/{groupId}/{clusterTag}")
    public Call<Response<Boolean>> startTagSwitch(@Path(value="groupId") String var1, @Path(value="clusterTag") String var2);

    @GET(value="group/switch/finish/{groupId}")
    public Call<Response<Boolean>> finishTagSwitch(@Path(value="groupId") String var1);

    @POST(value="group/submitOfflineJob")
    public Call<Response<Boolean>> submitOfflineJob(@Body OfflineJobRequest var1);
}

