/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.core.Username;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeleteUserDataService {
    private final Set<DeleteUserDataTaskStep> steps;

    @Inject
    public DeleteUserDataService(Set<DeleteUserDataTaskStep> steps) {
        this.steps = steps;
    }

    public Performer performer(Optional<DeleteUserDataTaskStep.StepName> fromStep) {
        return new Performer(this.steps, new DeleteUserDataStatus(this.steps), fromStep);
    }

    public Performer performer() {
        return new Performer(this.steps, new DeleteUserDataStatus(this.steps), Optional.empty());
    }

    public static class Performer {
        private final Set<DeleteUserDataTaskStep> steps;
        private final DeleteUserDataStatus status;
        private final Optional<Integer> correspondingPriority;

        public Performer(Set<DeleteUserDataTaskStep> steps, DeleteUserDataStatus status, Optional<DeleteUserDataTaskStep.StepName> fromStep) {
            this.steps = steps;
            this.status = status;
            this.correspondingPriority = fromStep.map(this::correspondingPriority);
        }

        public Mono<Void> deleteUserData(Username username) {
            this.correspondingPriority.ifPresent(priority -> this.steps.stream().filter(step -> step.priority() < priority).forEach(step -> this.status.skipStep(step.name())));
            return this.steps().concatMap(step -> Mono.fromRunnable(() -> this.status.beginStep(step.name())).then(Mono.from((Publisher)step.deleteUserData(username))).then(Mono.fromRunnable(() -> this.status.endStep(step.name()))).doOnError(e -> this.status.failedStep(step.name()))).doOnError(e -> this.status.abort()).then();
        }

        private Flux<DeleteUserDataTaskStep> steps() {
            return this.correspondingPriority.map(priority -> Flux.fromIterable(this.steps).filter(step -> step.priority() >= priority).sort(Comparator.comparingInt(DeleteUserDataTaskStep::priority))).orElseGet(() -> Flux.fromIterable(this.steps).sort(Comparator.comparingInt(DeleteUserDataTaskStep::priority)));
        }

        private int correspondingPriority(DeleteUserDataTaskStep.StepName stepName) {
            return this.steps.stream().filter(step -> step.name().equals((Object)stepName)).map(DeleteUserDataTaskStep::priority).findAny().orElseThrow(() -> new IllegalArgumentException("Starting step not found: " + stepName.asString()));
        }

        public DeleteUserDataStatus getStatus() {
            return this.status;
        }
    }

    public static class DeleteUserDataStatus {
        private final Map<DeleteUserDataTaskStep.StepName, StepState> states;

        public DeleteUserDataStatus(Set<DeleteUserDataTaskStep> steps) {
            this.states = new ConcurrentHashMap<DeleteUserDataTaskStep.StepName, StepState>((Map)steps.stream().collect(ImmutableMap.toImmutableMap(DeleteUserDataTaskStep::name, any -> StepState.WAITING)));
        }

        public void beginStep(DeleteUserDataTaskStep.StepName step) {
            this.states.put(step, StepState.IN_PROGRESS);
        }

        public void endStep(DeleteUserDataTaskStep.StepName step) {
            this.states.put(step, StepState.DONE);
        }

        public void failedStep(DeleteUserDataTaskStep.StepName step) {
            this.states.put(step, StepState.FAILED);
        }

        public void abortStep(DeleteUserDataTaskStep.StepName step) {
            this.states.put(step, StepState.ABORTED);
        }

        public void skipStep(DeleteUserDataTaskStep.StepName step) {
            this.states.put(step, StepState.SKIPPED);
        }

        public void abort() {
            this.states.entrySet().stream().filter(entry -> entry.getValue() == StepState.WAITING || entry.getValue() == StepState.IN_PROGRESS).forEach(entry -> this.abortStep((DeleteUserDataTaskStep.StepName)entry.getKey()));
        }

        public Map<DeleteUserDataTaskStep.StepName, StepState> getStates() {
            return ImmutableMap.copyOf(this.states);
        }
    }

    public static enum StepState {
        WAITING,
        IN_PROGRESS,
        DONE,
        FAILED,
        ABORTED,
        SKIPPED;

    }
}

