/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import org.apache.james.DefaultVacationService;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.VacationDeleteUserTaskStep;
import org.apache.james.vacation.api.VacationRepository;
import org.apache.james.vacation.api.VacationService;
import org.apache.james.vacation.postgres.PostgresNotificationRegistry;
import org.apache.james.vacation.postgres.PostgresVacationDataDefinition;
import org.apache.james.vacation.postgres.PostgresVacationRepository;

public class PostgresVacationModule
extends AbstractModule {
    public void configure() {
        this.bind(DefaultVacationService.class).in(Scopes.SINGLETON);
        this.bind(VacationService.class).to(DefaultVacationService.class);
        this.bind(PostgresVacationRepository.class).in(Scopes.SINGLETON);
        this.bind(VacationRepository.class).to(PostgresVacationRepository.class);
        this.bind(PostgresNotificationRegistry.class).in(Scopes.SINGLETON);
        this.bind(NotificationRegistry.class).to(PostgresNotificationRegistry.class);
        Multibinder postgresVacationModules = Multibinder.newSetBinder((Binder)this.binder(), PostgresDataDefinition.class);
        postgresVacationModules.addBinding().toInstance((Object)PostgresVacationDataDefinition.MODULE);
        Multibinder deleteUserDataTaskSteps = Multibinder.newSetBinder((Binder)this.binder(), DeleteUserDataTaskStep.class);
        deleteUserDataTaskSteps.addBinding().to(VacationDeleteUserTaskStep.class);
    }
}

