/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.matchers;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.james.core.MailAddress;
import org.apache.james.mailetcontainer.impl.matchers.GenericCompositeMatcher;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;

public class Xor
extends GenericCompositeMatcher {
    public Collection<MailAddress> match(Mail mail) {
        Set recipients = (Set)this.getMatchers().stream().map(Throwing.function(matcher -> this.applyMatcher(mail, (Matcher)matcher)).sneakyThrow()).reduce(ImmutableSet.of(), this::performXor);
        if (recipients.isEmpty()) {
            return null;
        }
        return recipients;
    }

    private Set<MailAddress> applyMatcher(Mail mail, Matcher matcher) throws MessagingException {
        return (Set)Optional.ofNullable(matcher.match(mail)).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
    }

    private Set<MailAddress> performXor(Set<MailAddress> set1, Set<MailAddress> set2) {
        return Sets.difference((Set)Sets.union(set1, set2), (Set)Sets.intersection(set1, set2));
    }
}

