/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataSnapshotRecord;

public class RemoteLogSegmentMetadataSnapshotRecordJsonConverter {
    public static RemoteLogSegmentMetadataSnapshotRecord read(JsonNode _node, short _version) {
        RemoteLogSegmentMetadataSnapshotRecord _object = new RemoteLogSegmentMetadataSnapshotRecord();
        JsonNode _segmentIdNode = _node.get("segmentId");
        if (_segmentIdNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'segmentId', which is mandatory in version " + _version);
        }
        if (!_segmentIdNode.isTextual()) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.segmentId = Uuid.fromString((String)_segmentIdNode.asText());
        JsonNode _startOffsetNode = _node.get("startOffset");
        if (_startOffsetNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'startOffset', which is mandatory in version " + _version);
        }
        _object.startOffset = MessageUtil.jsonNodeToLong((JsonNode)_startOffsetNode, (String)"RemoteLogSegmentMetadataSnapshotRecord");
        JsonNode _endOffsetNode = _node.get("endOffset");
        if (_endOffsetNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'endOffset', which is mandatory in version " + _version);
        }
        _object.endOffset = MessageUtil.jsonNodeToLong((JsonNode)_endOffsetNode, (String)"RemoteLogSegmentMetadataSnapshotRecord");
        JsonNode _brokerIdNode = _node.get("brokerId");
        if (_brokerIdNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'brokerId', which is mandatory in version " + _version);
        }
        _object.brokerId = MessageUtil.jsonNodeToInt((JsonNode)_brokerIdNode, (String)"RemoteLogSegmentMetadataSnapshotRecord");
        JsonNode _maxTimestampMsNode = _node.get("maxTimestampMs");
        if (_maxTimestampMsNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'maxTimestampMs', which is mandatory in version " + _version);
        }
        _object.maxTimestampMs = MessageUtil.jsonNodeToLong((JsonNode)_maxTimestampMsNode, (String)"RemoteLogSegmentMetadataSnapshotRecord");
        JsonNode _eventTimestampMsNode = _node.get("eventTimestampMs");
        if (_eventTimestampMsNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'eventTimestampMs', which is mandatory in version " + _version);
        }
        _object.eventTimestampMs = MessageUtil.jsonNodeToLong((JsonNode)_eventTimestampMsNode, (String)"RemoteLogSegmentMetadataSnapshotRecord");
        JsonNode _segmentLeaderEpochsNode = _node.get("segmentLeaderEpochs");
        if (_segmentLeaderEpochsNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'segmentLeaderEpochs', which is mandatory in version " + _version);
        }
        if (!_segmentLeaderEpochsNode.isArray()) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry> _collection = new ArrayList<RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry>(_segmentLeaderEpochsNode.size());
        _object.segmentLeaderEpochs = _collection;
        for (JsonNode _element : _segmentLeaderEpochsNode) {
            _collection.add(SegmentLeaderEpochEntryJsonConverter.read(_element, _version));
        }
        JsonNode _segmentSizeInBytesNode = _node.get("segmentSizeInBytes");
        if (_segmentSizeInBytesNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'segmentSizeInBytes', which is mandatory in version " + _version);
        }
        _object.segmentSizeInBytes = MessageUtil.jsonNodeToInt((JsonNode)_segmentSizeInBytesNode, (String)"RemoteLogSegmentMetadataSnapshotRecord");
        JsonNode _customMetadataNode = _node.get("customMetadata");
        if (_customMetadataNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'customMetadata', which is mandatory in version " + _version);
        }
        _object.customMetadata = (byte[])(_customMetadataNode.isNull() ? null : MessageUtil.jsonNodeToBinary((JsonNode)_customMetadataNode, (String)"RemoteLogSegmentMetadataSnapshotRecord"));
        JsonNode _remoteLogSegmentStateNode = _node.get("remoteLogSegmentState");
        if (_remoteLogSegmentStateNode == null) {
            throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord: unable to locate field 'remoteLogSegmentState', which is mandatory in version " + _version);
        }
        _object.remoteLogSegmentState = MessageUtil.jsonNodeToByte((JsonNode)_remoteLogSegmentStateNode, (String)"RemoteLogSegmentMetadataSnapshotRecord");
        JsonNode _txnIndexEmptyNode = _node.get("txnIndexEmpty");
        if (_txnIndexEmptyNode == null) {
            _object.txnIndexEmpty = false;
        } else {
            if (!_txnIndexEmptyNode.isBoolean()) {
                throw new RuntimeException("RemoteLogSegmentMetadataSnapshotRecord expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.txnIndexEmpty = _txnIndexEmptyNode.asBoolean();
        }
        return _object;
    }

    public static JsonNode write(RemoteLogSegmentMetadataSnapshotRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("segmentId", (JsonNode)new TextNode(_object.segmentId.toString()));
        _node.set("startOffset", (JsonNode)new LongNode(_object.startOffset));
        _node.set("endOffset", (JsonNode)new LongNode(_object.endOffset));
        _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
        _node.set("maxTimestampMs", (JsonNode)new LongNode(_object.maxTimestampMs));
        _node.set("eventTimestampMs", (JsonNode)new LongNode(_object.eventTimestampMs));
        ArrayNode _segmentLeaderEpochsArray = new ArrayNode(JsonNodeFactory.instance);
        for (RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry _element : _object.segmentLeaderEpochs) {
            _segmentLeaderEpochsArray.add(SegmentLeaderEpochEntryJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("segmentLeaderEpochs", (JsonNode)_segmentLeaderEpochsArray);
        _node.set("segmentSizeInBytes", (JsonNode)new IntNode(_object.segmentSizeInBytes));
        if (_object.customMetadata == null) {
            _node.set("customMetadata", (JsonNode)NullNode.instance);
        } else {
            _node.set("customMetadata", (JsonNode)new BinaryNode(Arrays.copyOf(_object.customMetadata, _object.customMetadata.length)));
        }
        _node.set("remoteLogSegmentState", (JsonNode)new ShortNode((short)_object.remoteLogSegmentState));
        if (_object.txnIndexEmpty) {
            _node.set("txnIndexEmpty", (JsonNode)BooleanNode.valueOf((boolean)_object.txnIndexEmpty));
        }
        return _node;
    }

    public static JsonNode write(RemoteLogSegmentMetadataSnapshotRecord _object, short _version) {
        return RemoteLogSegmentMetadataSnapshotRecordJsonConverter.write(_object, _version, true);
    }

    public static class SegmentLeaderEpochEntryJsonConverter {
        public static RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry read(JsonNode _node, short _version) {
            RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry _object = new RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry();
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("SegmentLeaderEpochEntry: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt((JsonNode)_leaderEpochNode, (String)"SegmentLeaderEpochEntry");
            JsonNode _offsetNode = _node.get("offset");
            if (_offsetNode == null) {
                throw new RuntimeException("SegmentLeaderEpochEntry: unable to locate field 'offset', which is mandatory in version " + _version);
            }
            _object.offset = MessageUtil.jsonNodeToLong((JsonNode)_offsetNode, (String)"SegmentLeaderEpochEntry");
            return _object;
        }

        public static JsonNode write(RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
            _node.set("offset", (JsonNode)new LongNode(_object.offset));
            return _node;
        }

        public static JsonNode write(RemoteLogSegmentMetadataSnapshotRecord.SegmentLeaderEpochEntry _object, short _version) {
            return SegmentLeaderEpochEntryJsonConverter.write(_object, _version, true);
        }
    }
}

