/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

public enum ProviderOrder {
    WEBAPPSEC(1),
    AUTHENTICATION(2),
    FEDERATION(3),
    IDENTITY_ASSERTION(4),
    AUTHORIZATION(5),
    HOSTMAP(6),
    HA(7);

    final int ordinal;
    final String name;

    private ProviderOrder(int ordinal) {
        this.ordinal = ordinal;
        this.name = this.name().replace("_", "-");
    }

    static int getOrdinalForRole(String role) {
        int count = 0;
        for (ProviderOrder providerOrder : ProviderOrder.values()) {
            ++count;
            if (!providerOrder.name.equalsIgnoreCase(role)) continue;
            return providerOrder.ordinal;
        }
        return ++count;
    }
}

