/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.server.UserThreadPool;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UserThreadPoolManager {
    private static ConcurrentMap<String, UserThreadPool> userThreadMap = null;

    public static boolean hasUserThread() {
        return userThreadMap != null && userThreadMap.size() > 0;
    }

    public static synchronized void registerUserThread(String service, UserThreadPool userThreadPool) {
        if (userThreadMap == null) {
            userThreadMap = new ConcurrentHashMap<String, UserThreadPool>();
        }
        userThreadMap.put(service, userThreadPool);
    }

    public static synchronized void unRegisterUserThread(String service) {
        if (userThreadMap != null) {
            userThreadMap.remove(service);
        }
    }

    public static UserThreadPool getUserThread(String service) {
        return userThreadMap == null ? null : (UserThreadPool)userThreadMap.get(service);
    }

    public static Set<UserThreadPool> getUserThreadPoolSet() {
        HashSet<UserThreadPool> userThreadPoolSet = new HashSet<UserThreadPool>();
        if (UserThreadPoolManager.hasUserThread()) {
            userThreadPoolSet.addAll(userThreadMap.values());
        }
        return userThreadPoolSet;
    }
}

