/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.proxy.enhanced.service;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.common.dto.convert.rule.AiProxyHandle;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.ai.common.config.AiCommonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiProxyConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyConfigService.class);
    private static final String FALLBACK_CONFIG = "fallbackConfig";

    public AiCommonConfig resolvePrimaryConfig(AiProxyHandle handle) {
        AiCommonConfig globalConfig = (AiCommonConfig)Singleton.INST.get(AiCommonConfig.class);
        AiCommonConfig primaryConfig = new AiCommonConfig();
        if (Objects.nonNull(globalConfig)) {
            primaryConfig.mergeWith(globalConfig);
        }
        if (Objects.nonNull(handle)) {
            AiCommonConfig handleConfig = new AiCommonConfig();
            handleConfig.setProvider(handle.getProvider());
            handleConfig.setModel(handle.getModel());
            handleConfig.setApiKey(handle.getApiKey());
            handleConfig.setBaseUrl(handle.getBaseUrl());
            handleConfig.setTemperature(handle.getTemperature());
            handleConfig.setMaxTokens(handle.getMaxTokens());
            handleConfig.setStream(handle.getStream());
            primaryConfig.mergeWith(handleConfig);
        }
        return primaryConfig;
    }

    public Optional<AiCommonConfig> resolveDynamicFallbackConfig(AiCommonConfig primaryConfig, String requestBody) {
        return this.extractDynamicFallbackConfig(requestBody).map(dynamicConfig -> {
            LOG.info("Resolved dynamic fallback config: {}", dynamicConfig);
            return new AiCommonConfig(primaryConfig).mergeWith(dynamicConfig);
        });
    }

    public Optional<AiCommonConfig> resolveAdminFallbackConfig(AiCommonConfig primaryConfig, AiProxyHandle handle) {
        return Optional.ofNullable(handle).map(AiProxyHandle::getFallbackConfig).map(fallback -> {
            AiCommonConfig config = new AiCommonConfig();
            config.setProvider(fallback.getProvider());
            config.setModel(fallback.getModel());
            config.setApiKey(fallback.getApiKey());
            config.setBaseUrl(fallback.getBaseUrl());
            config.setTemperature(fallback.getTemperature());
            config.setMaxTokens(fallback.getMaxTokens());
            LOG.info("Resolved admin fallback config: {}", (Object)config);
            return new AiCommonConfig(primaryConfig).mergeWith(config);
        });
    }

    private Optional<AiCommonConfig> extractDynamicFallbackConfig(String requestBody) {
        if (Objects.isNull(requestBody) || requestBody.isEmpty()) {
            return Optional.empty();
        }
        JsonNode jsonNode = JsonUtils.toJsonNode((String)requestBody);
        if (jsonNode.has(FALLBACK_CONFIG)) {
            AiProxyHandle.FallbackConfig fallbackConfig = (AiProxyHandle.FallbackConfig)JsonUtils.jsonToObject((String)jsonNode.get(FALLBACK_CONFIG).toString(), AiProxyHandle.FallbackConfig.class);
            AiCommonConfig config = new AiCommonConfig();
            config.setProvider(fallbackConfig.getProvider());
            config.setModel(fallbackConfig.getModel());
            config.setApiKey(fallbackConfig.getApiKey());
            config.setBaseUrl(fallbackConfig.getBaseUrl());
            config.setTemperature(fallbackConfig.getTemperature());
            config.setMaxTokens(fallbackConfig.getMaxTokens());
            return Optional.of(config);
        }
        return Optional.empty();
    }
}

