/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.RecordCondition;
import org.apache.skywalking.oap.server.core.query.type.Record;
import org.apache.skywalking.oap.server.core.storage.query.IRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class RecordsQueryEsDAO
extends EsDAO
implements IRecordsQueryDAO {
    public RecordsQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<Record> readRecords(RecordCondition condition, String valueColumnName, Duration duration) throws IOException {
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucketInSec()).lte((Object)duration.getEndTimeBucketInSec()));
        if (IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)condition.getName()));
        }
        query.must((QueryBuilder)Query.term((String)"entity_id", (Object)condition.getParentEntity().buildId()));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(condition.getTopN())).sort(valueColumnName, condition.getOrder().equals((Object)Order.DES) ? Sort.Order.DESC : Sort.Order.ASC);
        SearchResponse response = this.searchDebuggable(IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName()), search.build());
        ArrayList<Record> results = new ArrayList<Record>(condition.getTopN());
        for (SearchHit searchHit : response.getHits().getHits()) {
            Record record = new Record();
            Map sourceAsMap = searchHit.getSource();
            record.setName((String)sourceAsMap.get("statement"));
            String refId = (String)sourceAsMap.get("trace_id");
            record.setRefId(StringUtil.isEmpty((String)refId) ? "" : refId);
            record.setId(record.getRefId());
            record.setValue(sourceAsMap.getOrDefault(valueColumnName, "0").toString());
            results.add(record);
        }
        return results;
    }
}

