/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.jcr.resource.internal.NodeUtil;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JcrNodeResourceMetadata
extends ResourceMetadata {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrNodeResourceMetadata.class);
    private final Node node;
    private Node contentNode;
    private boolean nodePromotionChecked = false;
    private long creationTime = -1L;
    private boolean populated = false;

    public JcrNodeResourceMetadata(@NotNull Node inNode) {
        this.node = inNode;
    }

    @NotNull
    private Node promoteNode() {
        try {
            if (!this.nodePromotionChecked && (this.node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file") || this.node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode") && this.node.getProperty("{http://www.jcp.org/jcr/1.0}frozenPrimaryType").getString().equals("{http://www.jcp.org/jcr/nt/1.0}file"))) {
                this.creationTime = this.node.getProperty("{http://www.jcp.org/jcr/1.0}created").getLong();
                if (!this.node.isNew() || this.node.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
                    this.contentNode = this.node.getNode("{http://www.jcp.org/jcr/1.0}content");
                }
                this.nodePromotionChecked = true;
            }
        }
        catch (RepositoryException re) {
            this.report(re);
        }
        return this.contentNode != null ? this.contentNode : this.node;
    }

    private void report(RepositoryException re) {
        String nodePath = "<unknown node path>";
        try {
            nodePath = this.contentNode != null ? this.contentNode.getPath() : this.node.getPath();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        LOGGER.info("setMetaData: Problem extracting metadata information for {}", (Object)nodePath, (Object)re);
    }

    public Object get(Object key) {
        Object result = super.get(key);
        if (result != null) {
            return result;
        }
        if ("sling.creationTime".equals(key)) {
            this.promoteNode();
            this.internalPut("sling.creationTime", this.creationTime);
            return this.creationTime;
        }
        if ("sling.contentType".equals(key)) {
            String contentType = this.getPropertyString(this.promoteNode(), "{http://www.jcp.org/jcr/1.0}mimeType");
            this.internalPut("sling.contentType", contentType);
            return contentType;
        }
        if ("sling.characterEncoding".equals(key)) {
            String characterEncoding = this.getPropertyString(this.promoteNode(), "{http://www.jcp.org/jcr/1.0}encoding");
            this.internalPut("sling.characterEncoding", characterEncoding);
            return characterEncoding;
        }
        if ("sling.modificationTime".equals(key)) {
            long modificationTime = this.getPropertyLong(this.promoteNode(), "{http://www.jcp.org/jcr/1.0}lastModified");
            this.internalPut("sling.modificationTime", modificationTime);
            return modificationTime;
        }
        if ("sling.contentLength".equals(key)) {
            long contentLength = this.getContentLength(this.promoteNode());
            this.internalPut("sling.contentLength", contentLength);
            return contentLength;
        }
        return null;
    }

    @Nullable
    private String getPropertyString(@NotNull Node node, @NotNull String propertyName) {
        try {
            Property property = NodeUtil.getPropertyOrNull(node, propertyName);
            if (property != null) {
                return property.getString();
            }
        }
        catch (RepositoryException re) {
            this.report(re);
        }
        return null;
    }

    private long getPropertyLong(@NotNull Node node, @NotNull String propertyName) {
        try {
            Property prop = NodeUtil.getPropertyOrNull(node, propertyName);
            if (prop != null) {
                try {
                    return prop.getLong();
                }
                catch (ValueFormatException vfe) {
                    LOGGER.debug("Property {} cannot be converted to a long, ignored ({})", (Object)prop.getPath(), (Object)vfe);
                }
            }
        }
        catch (RepositoryException re) {
            this.report(re);
        }
        return -1L;
    }

    private long getContentLength(@NotNull Node node) {
        try {
            Property prop = NodeUtil.getPropertyOrNull(node, "{http://www.jcp.org/jcr/1.0}data");
            if (prop != null) {
                return JcrItemResource.getContentLength(prop);
            }
            Item item = JcrNodeResourceMetadata.getPrimaryItem(node);
            while (item != null && item.isNode()) {
                item = JcrNodeResourceMetadata.getPrimaryItem((Node)item);
            }
            if (item != null) {
                Property data = (Property)item;
                return JcrItemResource.getContentLength(data);
            }
        }
        catch (RepositoryException re) {
            this.report(re);
        }
        return -1L;
    }

    @Nullable
    private static Item getPrimaryItem(@NotNull Node node) throws RepositoryException {
        String name = node.getPrimaryNodeType().getPrimaryItemName();
        if (name == null) {
            return null;
        }
        Property property = NodeUtil.getPropertyOrNull(node, name);
        if (property != null) {
            return property;
        }
        Node childNode = NodeUtil.getNodeOrNull(node, name);
        if (childNode != null) {
            return childNode;
        }
        return null;
    }

    private void populate() {
        if (this.populated) {
            return;
        }
        this.get("sling.creationTime");
        this.get("sling.contentType");
        this.get("sling.characterEncoding");
        this.get("sling.modificationTime");
        this.get("sling.contentLength");
        this.populated = true;
    }

    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        this.populate();
        return super.entrySet();
    }

    @NotNull
    public Set<String> keySet() {
        this.populate();
        return super.keySet();
    }

    @NotNull
    public Collection<Object> values() {
        this.populate();
        return super.values();
    }

    public int size() {
        this.populate();
        return super.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        return "sling.creationTime".equals(key) || "sling.contentType".equals(key) || "sling.characterEncoding".equals(key) || "sling.modificationTime".equals(key) || "sling.contentLength".equals(key);
    }

    public boolean containsValue(Object value) {
        if (super.containsValue(value)) {
            return true;
        }
        if (!this.populated) {
            this.populate();
            return super.containsValue(value);
        }
        return false;
    }
}

