/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeometryType$;
import org.json4s.JString;
import org.json4s.JValue;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001\u0002\u0012$\u00019B\u0001\"\u0011\u0001\u0003\u0006\u0004%\tA\u0011\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0007\")A\n\u0001C\u0005\u001b\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002,\u0001A\u0003%!\u000bC\u0003X\u0001\u0011\u0005\u0013\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003^\u0001\u0011\u0005#\tC\u0003_\u0001\u0011\u0005s\fC\u0003a\u0001\u0011\u0005\u0013\r\u0003\u0004p\u0001\u0011\u0005s\u0005\u001d\u0005\u0006c\u0002!\tE\u001d\u0005\u0006q\u0002!\t%\u001f\u0005\u0007u\u0002!\t%J>\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!A\u00111\u0002\u0001\u0005\u0002\u0015\niaB\u0004\u0002(\rB\t!!\u000b\u0007\r\t\u001a\u0003\u0012AA\u0016\u0011\u0019a%\u0003\"\u0001\u0002H!I\u0011\u0011\n\nC\u0002\u0013\u0015\u00111\n\u0005\t\u0003#\u0012\u0002\u0015!\u0004\u0002N!I\u00111\u000b\nC\u0002\u0013\u0015\u0011Q\u000b\u0005\t\u0003;\u0012\u0002\u0015!\u0004\u0002X!A\u0011q\f\nC\u0002\u00135\u0001\u000fC\u0004\u0002bI\u0001\u000bQ\u0002(\t\u000f\u0005\r$\u0003\"\u0001\u0002f!9\u0011\u0011\u000e\n\u0005\u0002\u0005-\u0004bBA5%\u0011\u0005\u0011q\u000e\u0005\t\u0003g\u0012B\u0011I\u0013\u0002v!9!P\u0005C!K\u0005]\u0004bBA>%\u0011\u0005SE\u0011\u0005\t\u0003{\u0012B\u0011A\u0012\u0002\u0000!I\u00111\u0011\n\u0002\u0002\u0013%\u0011Q\u0011\u0002\r\u000f\u0016|W.\u001a;ssRK\b/\u001a\u0006\u0003I\u0015\nQ\u0001^=qKNT!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00184!\t\u0001\u0014'D\u0001$\u0013\t\u00114E\u0001\u0006Bi>l\u0017n\u0019+za\u0016\u0004\"\u0001\u000e \u000f\u0005UZdB\u0001\u001c:\u001b\u00059$B\u0001\u001d.\u0003\u0019a$o\\8u}%\t!(A\u0003tG\u0006d\u0017-\u0003\u0002={\u00059\u0001/Y2lC\u001e,'\"\u0001\u001e\n\u0005}\u0002%\u0001D*fe&\fG.\u001b>bE2,'B\u0001\u001f>\u0003\r\u0019'o]\u000b\u0002\u0007B\u0011A\t\u0013\b\u0003\u000b\u001a\u0003\"AN\u001f\n\u0005\u001dk\u0014A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n11\u000b\u001e:j]\u001eT!aR\u001f\u0002\t\r\u00148\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059{\u0005C\u0001\u0019\u0001\u0011\u0015\t5\u00011\u0001D\u0003\u0011\u0019(/\u001b3\u0016\u0003I\u0003\"a\u0015+\u000e\u0003uJ!!V\u001f\u0003\u0007%sG/A\u0003te&$\u0007%A\u0006eK\u001a\fW\u000f\u001c;TSj,\u0017aC5t\u001b&DX\rZ*sS\u0012,\u0012A\u0017\t\u0003'nK!\u0001X\u001f\u0003\u000f\t{w\u000e\\3b]\u0006AA/\u001f9f\u001d\u0006lW-\u0001\u0005u_N#(/\u001b8h)\u0005\u0019\u0015!\u00036t_:4\u0016\r\\;f+\u0005\u0011\u0007CA2m\u001d\t!\u0017N\u0004\u0002fO:\u0011aGZ\u0005\u0002Y%\u0011\u0001nK\u0001\u0007UN|g\u000eN:\n\u0005)\\\u0017a\u0002&t_:\f5\u000b\u0016\u0006\u0003Q.J!!\u001c8\u0003\r)3\u0016\r\\;f\u0015\tQ7.\u0001\u0006bg:+H\u000e\\1cY\u0016,\u0012AT\u0001\u0007KF,\u0018\r\\:\u0015\u0005i\u001b\b\"\u0002;\r\u0001\u0004)\u0018aA8cUB\u00111K^\u0005\u0003ov\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#\u0001*\u0002\u0017\u0005\u001c7-\u001a9ugRK\b/\u001a\u000b\u00035rDQ! \bA\u0002y\fQa\u001c;iKJ\u0004\"\u0001M@\n\u0007\u0005\u00051E\u0001\u0005ECR\fG+\u001f9f\u0003M\t7mY3qiN<Um\\7fiJLH+\u001f9f)\rQ\u0016q\u0001\u0005\u0007\u0003\u0013y\u0001\u0019\u0001(\u0002\u0005\u001d$\u0018\u0001G1tg\u0016\u0014Ho\u0015:jI\u0006cGn\\<fI\u001a{'\u000fV=qKR!\u0011qBA\u000b!\r\u0019\u0016\u0011C\u0005\u0004\u0003'i$\u0001B+oSRDa!a\u0006\u0011\u0001\u0004\u0011\u0016!C8uQ\u0016\u00148K]5eQ\r\u0001\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005}!\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0017\u0001D$f_6,GO]=UsB,\u0007C\u0001\u0019\u0013'\u001d\u0011\u0012QFA\u001a\u0003s\u00012\u0001MA\u0018\u0013\r\t\td\t\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\u00042\u0001MA\u001b\u0013\r\t9d\t\u0002\f'B\fG/[1m)f\u0004X\r\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u0005%|'BAA\"\u0003\u0011Q\u0017M^1\n\u0007}\ni\u0004\u0006\u0002\u0002*\u0005)r)R(N\u000bR\u0013\u0016l\u0018#F\r\u0006+F\nV0T%&#UCAA'\u001f\t\ty%\b\u0002\u0011M\b1r)R(N\u000bR\u0013\u0016l\u0018#F\r\u0006+F\nV0T%&#\u0005%\u0001\u000bH\u000b>kU\t\u0016*Z?\u0012+e)Q+M)~\u001b%kU\u000b\u0003\u0003/z!!!\u0017\"\u0005\u0005m\u0013!C(H\u0007j\u001a%k\u0015\u001d5\u0003U9UiT'F)JKv\fR#G\u0003VcEkX\"S'\u0002\n1cR#P\u001b\u0016#&+W0N\u0013b+Ei\u0018+Z!\u0016\u000bAcR#P\u001b\u0016#&+W0N\u0013b+Ei\u0018+Z!\u0016\u0003\u0013aD5t'JLGmU;qa>\u0014H/\u001a3\u0015\u0007i\u000b9\u0007C\u0003Q5\u0001\u0007!+A\u0003baBd\u0017\u0010F\u0002O\u0003[BQ\u0001U\u000eA\u0002I#2ATA9\u0011\u0015\tE\u00041\u0001D\u0003M!WMZ1vYR\u001cuN\\2sKR,G+\u001f9f+\u0005qHc\u0001.\u0002z!)QP\ba\u0001}\u0006a1/[7qY\u0016\u001cFO]5oO\u00061Ao\\*sS\u0012$2AUAA\u0011\u0015\t\u0005\u00051\u0001D\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\t\u0005\u0003\u0002\n\u0006=UBAAF\u0015\u0011\ti)!\u0011\u0002\t1\fgnZ\u0005\u0005\u0003#\u000bYI\u0001\u0004PE*,7\r\u001e\u0015\u0004%\u0005m\u0001fA\t\u0002\u001c\u0001")
public class GeometryType
extends AtomicType
implements Serializable {
    private final String crs;
    private final int srid;

    public static GeometryType apply(String crs) {
        return GeometryType$.MODULE$.apply(crs);
    }

    public static GeometryType apply(int srid) {
        return GeometryType$.MODULE$.apply(srid);
    }

    public static boolean isSridSupported(int srid) {
        return GeometryType$.MODULE$.isSridSupported(srid);
    }

    public static String GEOMETRY_DEFAULT_CRS() {
        return GeometryType$.MODULE$.GEOMETRY_DEFAULT_CRS();
    }

    public static int GEOMETRY_DEFAULT_SRID() {
        return GeometryType$.MODULE$.GEOMETRY_DEFAULT_SRID();
    }

    public static String MIXED_CRS() {
        return GeometryType$.MODULE$.MIXED_CRS();
    }

    public static int MIXED_SRID() {
        return GeometryType$.MODULE$.MIXED_SRID();
    }

    public String crs() {
        return this.crs;
    }

    public int srid() {
        return this.srid;
    }

    @Override
    public int defaultSize() {
        return 2048;
    }

    public boolean isMixedSrid() {
        return this.srid() == GeometryType$.MODULE$.MIXED_SRID();
    }

    @Override
    public String typeName() {
        if (this.isMixedSrid()) {
            return "geometry(any)";
        }
        return "geometry(" + this.srid() + ")";
    }

    public String toString() {
        if (this.isMixedSrid()) {
            return "GeometryType(ANY)";
        }
        return "GeometryType(" + this.srid() + ")";
    }

    @Override
    public JValue jsonValue() {
        return new JString("geometry(" + this.crs() + ")");
    }

    @Override
    public GeometryType asNullable() {
        return this;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)object;
            return geometryType.srid() == this.srid();
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.srid());
    }

    @Override
    public boolean acceptsType(DataType other) {
        DataType dataType = other;
        if (dataType instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)dataType;
            return this.acceptsGeometryType(geometryType);
        }
        return false;
    }

    public boolean acceptsGeometryType(GeometryType gt) {
        return this.isMixedSrid() || gt.srid() == this.srid();
    }

    public void assertSridAllowedForType(int otherSrid) {
        if (!this.isMixedSrid() && otherSrid != this.srid()) {
            throw new SparkRuntimeException("GEO_ENCODER_SRID_MISMATCH_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"GEOMETRY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueSrid"), (Object)Integer.toString(otherSrid)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeSrid"), (Object)Integer.toString(this.srid()))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.isMixedSrid()) {
            if (!GeometryType$.MODULE$.isSridSupported(otherSrid)) {
                throw new SparkIllegalArgumentException("ST_INVALID_SRID_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srid"), (Object)Integer.toString(otherSrid))})));
            }
            return;
        }
    }

    public GeometryType(String crs) {
        this.crs = crs;
        this.srid = GeometryType$.MODULE$.toSrid(crs);
    }
}

