/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.V2TableReference;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.V2TableUtil$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class V2TableReferenceUtils$
implements SQLConfHelper {
    public static final V2TableReferenceUtils$ MODULE$ = new V2TableReferenceUtils$();

    static {
        SQLConfHelper.$init$(MODULE$);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public void validateLoadedTable(Table table, V2TableReference ref) {
        V2TableReference.Context context = ref.context();
        if (context instanceof V2TableReference.TemporaryViewContext) {
            V2TableReference.TemporaryViewContext temporaryViewContext = (V2TableReference.TemporaryViewContext)context;
            this.validateLoadedTableInTempView(table, ref, temporaryViewContext);
            return;
        }
        throw SparkException$.MODULE$.internalError("Unknown table ref context: " + context.getClass().getName());
    }

    private void validateLoadedTableInTempView(Table table, V2TableReference ref, V2TableReference.TemporaryViewContext ctx) {
        Seq<String> tableName = CatalogV2Implicits$.MODULE$.IdentifierHelper(ref.identifier()).toQualifiedNameParts(ref.catalog());
        Seq<String> dataErrors = V2TableUtil$.MODULE$.validateCapturedColumns(table, ref.info().columns());
        if (dataErrors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.columnsChangedAfterViewWithPlanCreation(ctx.viewName(), tableName, dataErrors);
        }
        Seq<String> metaErrors = V2TableUtil$.MODULE$.validateCapturedMetadataColumns(table, ref.info().metadataColumns());
        if (metaErrors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.metadataColumnsChangedAfterViewWithPlanCreation(ctx.viewName(), tableName, metaErrors);
        }
    }

    private V2TableReferenceUtils$() {
    }
}

