/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.FsHistoryProvider$;
import org.apache.spark.deploy.history.FsHistoryProviderMetadata;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.History$;
import org.apache.spark.internal.config.History$HybridStoreDiskBackend$;
import org.apache.spark.internal.config.History$LocalStoreSerializer$;
import org.apache.spark.status.AppStatusStore$;
import org.apache.spark.status.KVUtils;
import org.apache.spark.status.protobuf.KVStoreProtobufSerializer;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.InMemoryStore;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreSerializer;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.LevelDB;
import org.apache.spark.util.kvstore.RocksDB;
import org.apache.spark.util.kvstore.UnsupportedStoreVersionException;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class KVUtils$
implements Logging {
    public static final KVUtils$ MODULE$ = new KVUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Enumeration.Value backend(SparkConf conf, boolean live) {
        if (live) {
            return History$HybridStoreDiskBackend$.MODULE$.ROCKSDB();
        }
        return History$HybridStoreDiskBackend$.MODULE$.withName(conf.get(History$.MODULE$.HYBRID_STORE_DISK_BACKEND()));
    }

    private KVUtils.KVStoreScalaSerializer serializer(SparkConf conf, boolean live) {
        if (live) {
            return new KVStoreProtobufSerializer();
        }
        return this.serializerForHistoryServer(conf);
    }

    public <M> KVStore open(File path, M metadata, SparkConf conf, boolean live, ClassTag<M> evidence$1) {
        LevelDB levelDB;
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable)() -> "Metadata is required.");
        KVUtils.KVStoreScalaSerializer kvSerializer = this.serializer(conf, live);
        Enumeration.Value value = this.backend(conf, live);
        Enumeration.Value value2 = History$HybridStoreDiskBackend$.MODULE$.LEVELDB();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The LEVELDB is deprecated. Please use ROCKSDB instead.");
            levelDB = new LevelDB(path, (KVStoreSerializer)kvSerializer);
        } else {
            Enumeration.Value value4 = History$HybridStoreDiskBackend$.MODULE$.ROCKSDB();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                levelDB = new RocksDB(path, (KVStoreSerializer)kvSerializer);
            } else {
                throw new MatchError((Object)value);
            }
        }
        LevelDB db = levelDB;
        Object dbMeta = db.getMetadata(package$.MODULE$.classTag(evidence$1).runtimeClass());
        if (dbMeta == null) {
            db.setMetadata(metadata);
        } else if (!BoxesRunTime.equals((Object)dbMeta, metadata)) {
            db.close();
            throw new KVUtils.MetadataMismatchException();
        }
        return db;
    }

    public KVUtils.KVStoreScalaSerializer serializerForHistoryServer(SparkConf conf) {
        Enumeration.Value value = History$LocalStoreSerializer$.MODULE$.withName(conf.get(History$.MODULE$.LOCAL_STORE_SERIALIZER()));
        Enumeration.Value value2 = History$LocalStoreSerializer$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new KVUtils.KVStoreScalaSerializer();
        }
        Enumeration.Value value4 = History$LocalStoreSerializer$.MODULE$.PROTOBUF();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return new KVStoreProtobufSerializer();
        }
        throw new IllegalArgumentException("Unrecognized KV store serializer " + value);
    }

    public KVStore createKVStore(Option<File> storePath, boolean live, SparkConf conf) {
        return (KVStore)storePath.map((Function1 & Serializable)path -> {
            KVStore kVStore;
            String string;
            Enumeration.Value diskBackend;
            Enumeration.Value value = diskBackend = MODULE$.backend(conf, live);
            Enumeration.Value value2 = History$HybridStoreDiskBackend$.MODULE$.LEVELDB();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = "listing.ldb";
            } else {
                Enumeration.Value value4 = History$HybridStoreDiskBackend$.MODULE$.ROCKSDB();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = "listing.rdb";
                } else {
                    throw new MatchError((Object)value);
                }
            }
            String dir = string;
            File dbPath = Files.createDirectories(new File((File)path, dir).toPath(), new FileAttribute[0]).toFile();
            Utils$.MODULE$.chmod700(dbPath);
            FsHistoryProviderMetadata metadata = new FsHistoryProviderMetadata(FsHistoryProvider$.MODULE$.CURRENT_LISTING_VERSION(), AppStatusStore$.MODULE$.CURRENT_VERSION(), conf.get(History$.MODULE$.HISTORY_LOG_DIR()));
            try {
                kVStore = MODULE$.open(dbPath, metadata, conf, live, ClassTag$.MODULE$.apply(FsHistoryProviderMetadata.class));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof UnsupportedStoreVersionException ? true : throwable2 instanceof KVUtils.MetadataMismatchException) {
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Detected incompatible DB versions, deleting...");
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])path.listFiles()), (Function1 & Serializable)file -> {
                        Utils$.MODULE$.deleteRecursively(file);
                        return BoxedUnit.UNIT;
                    });
                    kVStore = MODULE$.open(dbPath, metadata, conf, live, ClassTag$.MODULE$.apply(FsHistoryProviderMetadata.class));
                }
                if (throwable2 instanceof NativeDB.DBException ? true : throwable2 instanceof RocksDBException) {
                    MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load disk store ", " :"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATH, dbPath)}))), throwable2);
                    Utils$.MODULE$.deleteRecursively(dbPath);
                    kVStore = MODULE$.open(dbPath, metadata, conf, live, ClassTag$.MODULE$.apply(FsHistoryProviderMetadata.class));
                }
                throw throwable;
            }
            return kVStore;
        }).getOrElse((Function0 & Serializable)() -> new InMemoryStore());
    }

    public <T> Seq<T> viewToSeq(KVStoreView<T> view, int max, Function1<T, Object> filter) {
        List list;
        try (KVStoreIterator iter = view.closeableIterator();){
            list = CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iter).asScala().filter(filter).take(max).toList();
        }
        return list;
    }

    public <T> Seq<T> viewToSeq(KVStoreView<T> view, int from, int until, Function1<T, Object> filter) {
        return (Seq)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> view.closeableIterator(), (Function1 & Serializable)iter -> CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iter).asScala().filter(filter).slice(from, until).toList());
    }

    public <T> Seq<T> viewToSeq(KVStoreView<T> view) {
        return (Seq)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> view.closeableIterator(), (Function1 & Serializable)iter -> CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iter).asScala().toList());
    }

    public <T> int count(KVStoreView<T> view, Function1<T, Object> countFunc) {
        return BoxesRunTime.unboxToInt(Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> view.closeableIterator(), (Function1 & Serializable)iter -> BoxesRunTime.boxToInteger((int)KVUtils$.$anonfun$count$2(countFunc, iter))));
    }

    public <T> void foreach(KVStoreView<T> view, Function1<T, BoxedUnit> foreachFunc) {
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> view.closeableIterator(), (Function1 & Serializable)iter -> {
            KVUtils$.$anonfun$foreach$2(foreachFunc, iter);
            return BoxedUnit.UNIT;
        });
    }

    public <T, B> Seq<B> mapToSeq(KVStoreView<T> view, Function1<T, B> mapFunc) {
        return (Seq)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> view.closeableIterator(), (Function1 & Serializable)iter -> CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iter).asScala().map(mapFunc).toList());
    }

    public <T, B> Seq<B> mapToSeqWithFilter(KVStoreView<T> view, int max, Function1<T, B> mapFunc, Function1<B, Object> filterFunc) {
        return (Seq)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> view.closeableIterator(), (Function1 & Serializable)iter -> CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iter).asScala().map(mapFunc).filter(filterFunc).take(max).toList());
    }

    public <T> int size(KVStoreView<T> view) {
        return BoxesRunTime.unboxToInt(Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> view.closeableIterator(), (Function1 & Serializable)iter -> BoxesRunTime.boxToInteger((int)KVUtils$.$anonfun$size$2(iter))));
    }

    public static final /* synthetic */ int $anonfun$count$2(Function1 countFunc$1, KVStoreIterator iter) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iter).asScala().count(countFunc$1);
    }

    public static final /* synthetic */ void $anonfun$foreach$2(Function1 foreachFunc$1, KVStoreIterator iter) {
        CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iter).asScala().foreach(foreachFunc$1);
    }

    public static final /* synthetic */ int $anonfun$size$2(KVStoreIterator iter) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iter).asScala().size();
    }

    private KVUtils$() {
    }
}

