/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.io.grpc.internal;

import java.util.concurrent.Executor;
import org.sparkproject.connect.guava.annotations.VisibleForTesting;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.util.concurrent.ListenableFuture;
import org.sparkproject.connect.guava.util.concurrent.SettableFuture;
import org.sparkproject.io.grpc.CallOptions;
import org.sparkproject.io.grpc.ClientStreamTracer;
import org.sparkproject.io.grpc.InternalChannelz;
import org.sparkproject.io.grpc.InternalLogId;
import org.sparkproject.io.grpc.Metadata;
import org.sparkproject.io.grpc.MethodDescriptor;
import org.sparkproject.io.grpc.Status;
import org.sparkproject.io.grpc.internal.ClientStream;
import org.sparkproject.io.grpc.internal.ClientStreamListener;
import org.sparkproject.io.grpc.internal.ClientTransport;
import org.sparkproject.io.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error);
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

